import string,os,sys
sys.path.insert(0,'../')
sys.path.insert(0,'.')

from PyDisWindow import Plugin,ViewWindow
from PyDVT.GraphView import GraphFilter
from PyDVT.ImageView import ColormapFilter
import PyDVT.ExtendedGraphView as ExtendedGraphView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.DataSelection as DataSelection
import PyDVT.EdfFileData as EdfFileData
from scidxp.util import DefaultGroupNode
from scidxp.util import DefaultArray
from DataWrapper import DataToGroupNode
from SciDXPData import SciDXPData
from ReadHdf5File import ReadHdf5FileGroupNode
from WriteHdf5File import WriteHdf5File
from ReadMccdFile import ReadMccdFileGroupNode
from AzimInt import AzimIntDataSetNode
from Integration import IntegrationDataSetNode

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'
__date__= '20/09/2002'
__lastModif__='23/09/2002'

DEBUG=0

class Py4datHdf5Plugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datHdf5Plugin.OnStartInit...'
		return 0

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datHdf5Plugin.OnFinishInit...'
		self.app_window=app_window
	
	def OnFileOpen (self,filename,format_string):
        	if DEBUG: print 'In Py4datHdf5Plugin.OnFileOpen...'
		type=string.upper(format_string)
            	short_name= os.path.split(filename)[1]
            	print string.upper(type)[0:4]
		if string.upper(type)[0:4]=="HDF5":
			inputGroupNode=ReadHdf5FileGroupNode(filename)
			inputDataSetNode=inputGroupNode.getChild(inputGroupNode.getChildren().keys()[0])
			size=len(inputDataSetNode.getData().getData().shape)
			print 'size=',size
			if size==1: window=ViewWindow (self.app_window.mdi,ExtendedGraphView.ExtendedGraphView,short_name)
			elif size ==2: window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,short_name)
			else: return
                	window.shortName=short_name
                	window.fileName=filename
			sciData=SciDXPData()
                	window.Data=sciData
                	window.Data.SetSource(inputDataSetNode)
                	if size==1:
				window.DataSelection=DataSelection.OrthoLineSelection(window.Data)
                		window.Filter=GraphFilter(None,window.DataSelection)
				self.app_window.Set1DViewMenu(window)
			elif size==2: 
				window.DataSelection=DataSelection.RectSelection(window.Data)
				window.Filter=ColormapFilter(None,window.DataSelection)
				self.app_window.Set2DViewMenu(window)
			else: return
                	window.View.SetSource(window.Filter)
                	info=window.Data.GetSourceInfo()
                	window.NumImages=info["Size"] 
			window.Data.LoadSource()
	
	def OnFileSave (self,window,filename,format_string):
        	if DEBUG: print 'In Py4datHdf5Plugin.OnFileSave...'
		if window==None: return
		sourceWindow=self.GetSourceWindow(window)
		print 'sourceWindow=',sourceWindow.name,'/n','destinationFile=',filename
		azimWindow=self.app_window.GetWindow('AzimInt - '+ sourceWindow.name)
		if azimWindow!=None:
			ret=[]
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			for roi in azimWindow.rois.keys():
				ret.append(azimWindow.rois[roi])
			Limits = [ret[0].limits[0],ret[1].limits[0],ret[2].limits[0]]
			Limits.sort()
			ROI=Limits[1]
			BKG1=Limits[0]
			BKG2=Limits[2]
		
		if sourceWindow.shortName=='Stack':
			if azimWindow==None:
				print 'Do Azim Int and select Rois !........'
				return
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			image=0
			print 'fileName=',sourceWindow.fileName
			while image < sourceWindow.NumImages:
				if sourceWindow.fileName[image][-3:]=='edf':
					data=EdfFileData.EdfFileData()
					print 'DEBUG',type(sourceWindow.Mask),sourceWindow.fileName[image]
					data.SetSource(sourceWindow.fileName[image])
					data.LoadSource()
					groupNode=DataToGroupNode(data,'groupNode')
					datasetnode=groupNode.getChild('page0')
				elif sourceWindow.fileName[image][-4:]=='mccd':
					inputGroupNode=ReadMccdFileGroupNode(sourceWindow.fileName[image])
					datasetnode=inputGroupNode.getChild(inputGroupNode.getChildren().keys()[0])
				if hasattr(sourceWindow,'Mask'): 
					datasetnode._array=DefaultArray(datasetnode._array*sourceWindow.Mask)
				azimDataSetNode=AzimIntDataSetNode(datasetnode,pixelsize=sourceWindow.pixelsize,offset=sourceWindow.offset,center=sourceWindow.center) 
				Limits = [ret[0].limits[0],ret[1].limits[0],ret[2].limits[0]]
				Limits.sort()
				ROI=Limits[1]
				BKG1=Limits[0]
				BKG2=Limits[2]
				azimDataSetNode.setAttribute('ROI1',ROI)
				azimDataSetNode.setAttribute('ROI0',BKG1)
				azimDataSetNode.setAttribute('ROI2',BKG2)
				IntDataSetNode=IntegrationDataSetNode(azimDataSetNode)
				groupnode=DefaultGroupNode('')
				groupnode.insertChild(IntDataSetNode)
				name=string.split(sourceWindow.fileName[image],'/')[-1]
				file=string.split(filename,'.')
				initialFile=string.split(sourceWindow.fileName[image],'/')[-1]
				initialFile=string.split(initialFile,'.')[0]
				WriteHdf5File(file[0] + '_' + initialFile + '.' + file[1],groupnode)
				image=image+1
		else:
			data=window.View.GetSource()[0].GetSource().GetSource()
			groupNode=DataToGroupNode(data,'groupNode')
			print groupNode.getChildren()
			datasetnode=groupNode.getChild(groupNode.getChildren().keys()[0])
			groupnode=DefaultGroupNode('filename')
			groupnode.insertChild(datasetnode)
			WriteHdf5File(filename,groupnode)
	
	def GetOpenFormatList(self):
        	if DEBUG: print 'In Py4datHdf5Plugin.GetOpenFormatList...'
		return ["HDF5 files (*.hdf5)"]
		
	def GetSaveFormatList(self,window):
        	if DEBUG: print 'In Py4datHdf5Plugin.GetSaveFormatList...'
		return ["HDF5 files (*.hdf5)"]

	def GetInfoString(self):
		return "v. "+__version__+",  Author:"+__author__

    	########################################################
    	### Private
    	########################################################

    	def GetSourceWindow(self,window):
    		if window==None: return
		while window.master_window!=None:
			window=window.master_window
		return window	

			
plugin=Py4datHdf5Plugin()
