import types
from Numeric import array
from PyDVT.Filter import Filter
from ErrorWindow import ErrorWindow

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__   =  '05/12/2002'

DEBUG=0

class SubstractBackgroundFilter(Filter):
	def __init__(self,source,synchronized=1,buffer_input=0,Constant=1,BackgroundOutput=None):
		Filter.__init__(self,source,synchronized,buffer_input)
		if BackgroundOutput==None: 
			dial=ErrorWindow(None,message=' You must open 1 background image !',sizex=237,sizey=60)
			return
		self.BackgroundOutput=BackgroundOutput
		self.Constant=Constant
	
	def GetOutput(self):
		if DEBUG: print 'In SubstractBackgroundFilter.GetOutput...'
		sel=self.GetInput()
		data=sel['data']
		backgroundData=self.BackgroundOutput['data']
		if DEBUG: print type(data),data.shape,data[0,0]	
		if type(data)==types.NoneType or type(backgroundData)==types.NoneType: return
		if data.shape != backgroundData.shape:
			dial=ErrorWindow(None,message=' The 2 images must have the same shape !',sizex=237,sizey=60)
			return
		outputData = array(data) - self.Constant * array(backgroundData)
		
		if DEBUG: print type(outputData),outputData.shape, outputData[0,0]	
		return {'data': outputData}
	
