"""
    ConstantParameterDialog.py
    
"""
import Command
from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='05/12/2002'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'


class ConstantParameterDialog(QMainWindow):
	def __init__(self, parent,initial_parameters):
        	QMainWindow.__init__(self,parent,"Constant Parameter Dialog",0)  

		self.dlg=Dialog(self,"Constant",1,0)
        	box=QVBox( self.dlg )
		self.Constant=initial_parameters['Constant']
		
		box0 = QHBox( box )
        	box1 = QHBox( box )
		
        	lab1=QLabel(box0)
        	ed1=QLineEdit(box0)
		 
        	lab1.setText("Constant")
	 	lab1.setFixedWidth(60)
        	ed1.setText(QString(str(self.Constant)))
		ed1.setFixedWidth(60)
		
        	button=QPushButton(box1)
        	button.setText("OK")
		button.setFixedWidth(80)
		CancelButton=QPushButton(box1)
        	CancelButton.setText("Cancel")
		CancelButton.setFixedWidth(80)
        
		self.connect(button,SIGNAL("clicked()"),self.dlg.accept)
		self.connect(CancelButton,SIGNAL("clicked()"),self.dlg.reject)
        	box.resize( 200, 60 )
		
        	if self.dlg.exec_loop():
            		try: 
				self.Constant=float(str(ed1.text()))
            		except: pass
		

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=ConstantParameterDialog(None,{'Constant':8})
    app.setMainWidget (win)
    app.exec_loop()

