import types
from Numeric import array, Float32
from PyDVT.Filter import Filter

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '05/12/2002'

DEBUG=0

class AddConstantFilter(Filter):
	def __init__(self,source,synchronized=1,buffer_input=0,Constant=0):
		Filter.__init__(self,source,synchronized,buffer_input)
		self.Constant=Constant
		
	
	def GetOutput(self):
		if DEBUG: print 'In AddConstantFilter.GetOutput...'
		sel=self.GetInput()
		data=sel['data']	
		data=data.astype(Float32)
		if DEBUG: print data.shape,data[0,0]	
		if type(data)==types.NoneType: return
		
		outputData=array(data) + self.Constant
		
		if DEBUG: print outputData.shape, outputData[0,0]
			
		return {'data': outputData}
	
