from scidxp.util import *
import Numeric, threading, time, random, os, os.path, pprint, time, array
import EdfFile,string



class ReadEdfFileGroupNode(DefaultGroupNode):

	def __init__(self, filename):
		DefaultGroupNode.__init__(self,filename)
		self.readEdfFile(filename)
		self.setAttribute("Status",DefaultArray("OK"))
		self.setAttribute("StatusMessage",DefaultArray("No errors."))

      
	def readEdfFile(self, filename):
		try:
			children=self.getChildren()
			if children!={}:
				for child in children.keys():
					childNode=DefaultNode(child)
					self.removeChild(childNode)
			f=EdfFile.EdfFile(filename)
			self._nbPictures=f.NumImages
			
			if hasattr(f,'FileName'):
				self.setAttribute("Title",DefaultArray(str(f.FileName)))
			if hasattr(f,'SysByteOrder'):
				self.setAttribute("SysByteOrder",DefaultArray(f.SysByteOrder))
			if hasattr(f,'NumImages'):
				self.setAttribute("NumImages",DefaultArray(str(f.NumImages)))
		
			gn=0
			while gn<self._nbPictures:
			        #Index of picture
			        #image=f.GetData(gn)
			        #print image.shape
			        #print image[0:2,0:3]
				image_name='Image'+str(gn+1)
				#print image_name
				test_array=EdfArray(f,gn)
				test_data_set_node = DefaultDataSetNode(image_name,test_array) 
				if f.GetHeader(gn)!={}:
					l=len(f.GetHeader(gn))
					i=0
					while i<l:
						test_data_set_node.setAttribute(f.GetHeader(gn).keys()[i],DefaultArray(f.GetHeader(gn).values()[i]))
						i=i+1
				self.insertChild(test_data_set_node)
				gn=gn+1
			self.setAttribute("Status",DefaultArray("OK"))
			self.setAttribute("StatusMessage",DefaultArray("No errors."))
			#print self.getChildren()
		except:
			raise
			self.setAttribute("Status",DefaultArray("ERROR"))
			self.setAttribute("StatusMessage",DefaultArray("Something went wrong."))
				
				

class EdfArray(Array):
	def __init__(self,f,imageIndex):
		self._file=f
		self._imageIndex=imageIndex
		self._arrayChangeSupport=ArrayChangeSupport(self)
	
	def getRank(self):
		return 2
	
	def getExtends(self):
		extends=[]
		for d in self.getData().shape:
			extends.append(d)
		return extends
	
	def getExtend(self,dim):
		if dim==0: return self.getData().shape[0]
		elif dim==1: return self.getData().shape[1]
		else: print 'bad dimension'
	
	def getUnit(self):
		return ""
	
	def getDataCount(self):
		return self.getData().shape[0]*self.getData().shape[1]
	
	def getDataType(self):
		return Array.FLOAT64
	
	def getData(self):
		self.Array=self._file.GetData(self._imageIndex)
		return self.Array
	
	def getDataSlab(self,first,last):
		self.Array=self._file.GetData(self._imageIndex)[first[0]:last[0]+1,first[1]:last[1]+1]
		return self.Array
	
	def addArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._arrayChangeSupport.addArrayChangeEventListener(ArrayChangeEventListener)
	
	def removeArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._arrayChangeSupport.removeArrayChangeEventListener(ArrayChangeEventListener)
	
	def fireArrayChangeEvent(self,ArrayChangeEvent):
    		self._arrayChangeSupport.fireArrayChangeEvent(ArrayChangeEvent)



def test():
	data = ReadEdfFileGroupNode('test.edf')
	print 'name=',data.getName()
	print 'attributes=',data.getAttributes()
	print 'children=',data.getChildren()
	print 'child attributes:', data.getChild('Image1').getAttributes()
	#print dir(data.getChild('Image1').getAttribute('ROI1'))
	#test=data.getChild('Image1').getAttribute('ROI1').__repr__()
	#print test, eval(test)[0]
	#print type(test)
	#print map(ord,test)
	#print dir(test)
	#print data.getChild('Image1').getAttribute('ROI1')._data
	#print data.getChild('Image1').getAttribute('ROI1')._data.tolist()

if __name__=='__main__':
	test()
