"""
    En cours de MODIF !!!!
    Py4datMccdFile.py
    Generic class for Mccd files manipulation.    
"""

__author__ =  'Anne-Cecile Gendrin'
__version__=  '1.0'

################################################################################  
import sys, string
import Numeric
import os.path , tempfile, shutil
################################################################################
# constants
HEADER_BLOCK_SIZE = 1024
STATIC_HEADER_ELEMENTS=("HeaderID","Image","ByteOrder","DataType","Dim_1","Dim_2","Dim_3","Size")
STATIC_HEADER_ELEMENTS_CAPS=("HEADERID","IMAGE","BYTEORDER","DATATYPE","DIM_1","DIM_2","DIM_3","SIZE")

LOWER_CASE=0
UPPER_CASE=1

KEYS=1
VALUES=2

###############################################################################
class Image:
    """
    """
    def __init__(self):
        """ Constructor
        """
        self.Header={}
        self.Header={}
        self.HeaderPosition=0
        self.DataPosition=0
        self.Size=0
        self.NumDim=1
        self.Dim1=0
        self.Dim2=0
        self.Dim3=0
        self.DataType=""
        #for i in STATIC_HEADER_ELEMENTS: self.Header[i]=""
   
################################################################################

class  Py4datMccdFile:    
    """
    """
    ############################################################################
    #Interface
    def __init__(self,FileName):
        """ Constructor
            FileName:   Name of the file (either existing or to be created)  
        """
        self.Image=Image()
        self.FileName=FileName
        self.File = 0
        
        if sys.byteorder=="big": self.SysByteOrder="HighByteFirst"
        else: self.SysByteOrder="LowByteFirst"
        
        try:
            if os.path.isfile(self.FileName)==0:                
                print 'File creation'
		self.File = open(self.FileName, "wb")
                self.File.close()    

            if (os.access(self.FileName,os.W_OK)):
                self.File=open(self.FileName, "r+b")
            else : 
                self.File=open(self.FileName, "rb")

            self.File.seek(0, 0)
        except:
            try:
                self.File.close()
            except:
                pass
            raise "Py4datMccdFile: Error opening file"

        self.File.seek(0, 0)
        
        line = self.File.readline()        
        while line != "":            
            if string.count(line, "{\n") >= 1 or string.count(line, "{\r\n")>=1:             
                self.Image=Image()
                self.Image.HeaderPosition=self.File.tell()    
                
            if string.count(line, "=") >= 1:
                listItems = string.split(line, "=", 1)
                typeItem = string.strip(listItems[0])
                listItems = string.split(listItems[1], ";", 1)
                valueItem = string.strip(listItems[0])
                self.Image.Header[typeItem]=valueItem
            
	    if string.count(line, "}\n") >= 1:
                self.Image.DataPosition=self.File.tell()
                Par = SetDictCase(self.Image.Header,UPPER_CASE,KEYS)
                if "SIZE" in Par.keys():
                    self.Image.Size = string.atoi(Par["SIZE"])
                else:
                    raise "Py4datMccdFile: Image doesn't have size information"                
                if "DIM_1" in Par.keys():
                    self.Image.Dim1 = string.atoi(Par["DIM_1"])
                else:
                    raise "Py4datMccdFile: Image doesn't have dimension information"
                if "DIM_2" in Par.keys():
                    self.Image.NumDim=2
                    self.Image.Dim2 = string.atoi(Par["DIM_2"])
                if "DIM_3" in Par.keys():
                    self.Image.NumDim=3
                    self.Image.Dim3 = string.atoi(Par["DIM_3"])
                if "DATATYPE" in Par.keys():
                    self.Image.DataType=Par["DATATYPE"]
                else:
                    raise "Py4datMccdFile: Image doesn't have datatype information"
                if "BYTEORDER" in Par.keys():
                    self.Image.ByteOrder=Par["BYTEORDER"]
                else:
                    raise "Py4datMccdFile: Image doesn't have byteorder information"
                               
                self.File.seek(self.Image.Size, 1)
                
            line = self.File.readline()

    
    def GetData(self):
	Data = Numeric.fromstring(self.File.read())        
        return Data


    def GetPixel(self,Position):
        if len(Position)!= self.Image.NumDim: raise "Py4datMccdFile: coordinate with wrong dimension "
        
        size_pixel=self.__GetSizeNumericType__(self.__GetDefaultNumericType__(self.Image.DataType))
        offset=Position[0]*size_pixel
        if self.Image.NumDim>1:
            size_row=size_pixel * self.Image.Dim1
            offset=offset+ (Position[1]* size_row)
            if self.Image.NumDim==3:
                size_img=size_row * self.Image.Dim2
                offset=offset+ (Position[2]* size_img)
        self.File.seek(self.Image.DataPosition + offset,0)
        Data = Numeric.fromstring(self.File.read(size_pixel), self.__GetDefaultNumericType__(self.Image.DataType))
        if string.upper(self.SysByteOrder)!=string.upper(self.Image.ByteOrder):
            Data=Data.byteswapped()
        if  (self.Image.DataType=="UnsignedShort") or \
            (self.Image.DataType=="UnsignedInteger") or \
             (self.Image.DataType=="UnsignedLong"): 
            Data=self.__SetDataType__ (Data,"DoubleValue",1)
        else:
            Data=self.__SetDataType__ (Data,"DoubleValue",0)
        return Data[0]
         
        
    def GetHeader(self):
        #return self.Image.Header
        ret={}
        for i in self.Image.Header.keys():
            ret[i]=self.Image.Header[i]        
        return ret

        
    def GetHeader(self):
        #return self.Image.Header
        ret={}
        for i in self.Image.Header.keys():
            ret[i]=self.Image.Header[i]        
        return ret


    def WriteImage (self,Header,Data,Append=1,DataType="",WriteAsUnsigened=0,ByteOrder=""):
        if Append==0:
            self.File.truncate(0)
            self.Image=[]
            self.NumImages=0
        self.NumImages = self.NumImages + 1                
        self.Image.append(Image())

        #self.Image.Header["Dim_1"] = "%d" % Data.shape[1]
        #self.Image.Header["Dim_2"] = "%d" % Data.shape[0]
        if len(Data.shape)==1:
            self.Image.Dim1=Data.shape[0]
            self.Image.Header["Dim_1"] = "%d" % self.Image.Dim1
            self.Image.Size=(Data.shape[0]*self.__GetSizeNumericType__(Data.typecode()))
        elif len(Data.shape)==2:
            self.Image.Dim1=Data.shape[1]
            self.Image.Dim2=Data.shape[0]
            self.Image.Header["Dim_1"] = "%d" % self.Image.Dim1
            self.Image.Header["Dim_2"] = "%d" % self.Image.Dim2
            self.Image.Size=(Data.shape[0]*Data.shape[1]*self.__GetSizeNumericType__(Data.typecode()))
            self.Image.NumDim=2
        elif len(Data.shape)==3:
            self.Image.Dim1=Data.shape[2]
            self.Image.Dim2=Data.shape[1]
            self.Image.Dim3=Data.shape[0]
            self.Image.Header["Dim_1"] = "%d" % self.Image.Dim1
            self.Image.Header["Dim_2"] = "%d" % self.Image.Dim2
            self.Image.Header["Dim_3"] = "%d" % self.Image.Dim3
            self.Image.Size=(Data.shape[0]*Data.shape[1]*Data.shape[2]*self.__GetSizeNumericType__(Data.typecode()))
            self.Image.NumDim=3
        elif len(Data.shape)>3:
            raise "Py4datMccdFile: Data dimension not suported"
        

        if DataType=="":
            self.Image.DataType=self.__GetDefaultMccdType__(Data.typecode())
        else:
            self.Image.DataType=DataType
            Data=self.__SetDataType__ (Data,DataType,WriteAsUnsigened)
                            
        if ByteOrder=="":
            self.Image.ByteOrder=self.SysByteOrder
        else:
            self.Image.ByteOrder=ByteOrder
                
        self.Image.Header["Size"]  = "%d" % self.Image.Size
        self.Image.Header["Image"] = 1
        self.Image.Header["HeaderID"] = "EH:%06d:000000:000000" % self.Image.Header["Image"]
        self.Image.Header["ByteOrder"]=self.Image.ByteOrder
        self.Image.Header["DataType"]=self.Image.DataType

        
        self.Image.Header={}            
        self.File.seek(0,2)
        StrHeader = "{\n"
        for i in STATIC_HEADER_ELEMENTS:
            if i in self.Image.Header.keys():
                StrHeader = StrHeader + ("%s = %s ;\n" % (i , self.Image.Header[i]))
        for i in Header.keys():
            StrHeader = StrHeader + ("%s = %s ;\n" % (i,Header[i]))
            self.Image.Header[i]=Header[i]
        newsize=(((len(StrHeader)+1)/HEADER_BLOCK_SIZE)+1)*HEADER_BLOCK_SIZE -2                   
        StrHeader = string.ljust(StrHeader,newsize)
        StrHeader = StrHeader+"}\n"

        self.Image.HeaderPosition=self.File.tell()    
        self.File.write(StrHeader)
        self.Image.DataPosition=self.File.tell()

        #if self.Image.Header["ByteOrder"] != self.SysByteOrder:
        if string.upper(self.Image.ByteOrder) != string.upper(self.SysByteOrder):
            self.File.write((Data.byteswapped()).tostring())  
        else:
            self.File.write(Data.tostring())
        
        

    ############################################################################
    #Internal Methods
        
    def __GetDefaultNumericType__(self, MccdType):
        """ Internal method: returns NumPy type according to Edf type
        """
        return GetDefaultNumericType(MccdType)

    def __GetDefaultMccdType__(self, NumericType):
        """ Internal method: returns Edf type according Numpy type
        """
        if  NumericType  == "1":            return "SignedByte"
        elif NumericType == "b":            return "UnsignedByte"
        elif NumericType == "s":            return "SignedShort"          
        elif NumericType == "i":            return "SignedInteger"  
        elif NumericType == "l":            return "SignedLong"           
        elif NumericType == "f":            return "FloatValue"         
        elif NumericType == "d":            return "DoubleValue"
        else: raise "__GetDefaultMccdType__: unknown NumericType"


    def __GetSizeNumericType__(self, NumericType):
        """ Internal method: returns size of NumPy's Array Types
        """
        if  NumericType  == "1":            return 1
        elif NumericType == "b":            return 1
        elif NumericType == "s":            return 2         
        elif NumericType == "i":            return 4  
        elif NumericType == "l":            return 4           
        elif NumericType == "f":            return 4         
        elif NumericType == "d":            return 8
        else: raise "__GetSizeNumericType__: unknown NumericType"


    def __SetDataType__ (self,Array,DataType,UnsignedFlag=0):
        """ Internal method: array type convertion
        """
        SignBit  = {'s': 0x8000, 'i': 0x80000000, 'l': 0x80000000}
        TypeMask = {'s': 0xFFFF, 'i': 0xFFFFFFFF, 'l': 0xFFFFFFFF}
        TypeValue = {'s': 0x10000, 'i': 0x100000000L, 'l': 0x100000000L}

        FromMccdType= Array.typecode()
        ToMccdType= self.__GetDefaultNumericType__(DataType)
        if ToMccdType != FromMccdType:
            aux=Array.astype(self.__GetDefaultNumericType__(DataType))    
            if ((UnsignedFlag==1) and \
                (((FromMccdType ==  "s")     and (ToMccdType in ("i" ,"l","f","d"))) or\
                 ((FromMccdType in ("i","l"))and (ToMccdType in ("f","d"))) ) ):
                aux=Numeric.add(Numeric.less(aux,0)*TypeValue[FromMccdType] , aux)
                #Did this way because it raises error when converting from "O" to "s"                
                if aux.typecode()=="O": aux=aux.astype("d")
                aux=aux.astype(ToMccdType)
            return aux
        return Array

    def __del__(self):
        try:
            self.File.close()
        except:
            pass
        

def GetDefaultNumericType(MccdType):
    """ Returns NumPy type according Mccd type
    """
    MccdType=string.upper(MccdType)
    if   MccdType == "SIGNEDBYTE":       return "1"
    elif MccdType == "UNSIGNEDBYTE":     return "b"       
    elif MccdType == "SIGNEDSHORT":      return "s"
    elif MccdType == "UNSIGNEDSHORT":    return "s"
    elif MccdType == "SIGNEDINTEGER":    return "i"
    elif MccdType == "UNSIGNEDINTEGER":  return "i"
    elif MccdType == "SIGNEDLONG":       return "l"
    elif MccdType == "UNSIGNEDLONG":     return "l"
    elif MccdType == "FLOATVALUE":       return "f"
    elif MccdType == "FLOAT":            return "f"
    elif MccdType == "DOUBLEVALUE":      return "d"
    else: raise "__GetDefaultNumericType__: unknown MccdType"


def SetDictCase(Dict, Case, Flag):
    """ Returns dictionary with keys and/or values converted into upper or lowercase
        Dict:   input dictionary
        Case:   LOWER_CASE, UPPER_CASE
        Flag:   KEYS, VALUES or KEYS | VALUES        
    """
    newdict={}
    for i in Dict.keys():
        newkey=i
        newvalue=Dict[i]
        if Flag & KEYS:
            if Case == LOWER_CASE:  newkey = string.lower(newkey)
            else:                   newkey = string.upper(newkey)
        if Flag & VALUES:
            if Case == LOWER_CASE:  newvalue = string.lower(newvalue)
            else:                   newvalue = string.upper(newvalue)
        newdict[newkey]=newvalue
    return newdict    


def GetRegion(Arr,Pos,Size):
    """Returns array with refion of Arr.
       Arr must be 1d, 2d or 3d
       Pos and Size are tuples in the format (x) or (x,y) or (x,y,z)
       Both parameters must have the same size as the dimention of Arr
    """
    Dim=len(Arr.shape)
    if len(Pos) != Dim:  return None
    if len(Size) != Dim: return None
    
    if (Dim==1):
        SizeX=Size[0]
        if SizeX==0: SizeX=Arr.shape[0]-Pos[0]
        ArrRet=Numeric.take(Arr, range(Pos[0],Pos[0]+SizeX))
    elif (Dim==2):
        SizeX=Size[0]
        SizeY=Size[1]
        if SizeX==0: SizeX=Arr.shape[1]-Pos[0]
        if SizeY==0: SizeY=Arr.shape[0]-Pos[1]
        ArrRet=Numeric.take(Arr, range(Pos[1],Pos[1]+SizeY))
        ArrRet=Numeric.take(ArrRet, range(Pos[0],Pos[0]+SizeX),1)
    elif (Dim==3):
        SizeX=Size[0]
        SizeY=Size[1]
        SizeZ=Size[2]
        if SizeX==0: SizeX=Arr.shape[2]-Pos[0]
        if SizeY==0: SizeX=Arr.shape[1]-Pos[1]
        if SizeZ==0: SizeZ=Arr.shape[0]-Pos[2]
        ArrRet=Numeric.take(Arr, range(Pos[2],Pos[2]+SizeZ))
        ArrRet=Numeric.take(ArrRet, range(Pos[1],Pos[1]+SizeY),1)
        ArrRet=Numeric.take(ArrRet, range(Pos[0],Pos[0]+SizeX),2)
    else:
        ArrRet=None
    return ArrRet

#-------------------------------------------------------------------------------
if __name__ == "__main__":    
    f=Py4datMccdFile("../data/sc837_behenate_0003.mccd")
    arr=f.GetData()
    print arr, type(arr), arr.shape
    #x.WriteImage({},arr,0)
    
    exe=Py4datMccdFile("test.mccd")

    #Creates long array , filled with 0xFFFFFFFF(-1)
    la=Numeric.zeros((100,100))
    la=la-1
    
    #Creates a short array, filled with 0xFFFF
    sa=Numeric.zeros((100,100))
    sa=sa+0xFFFF
    sa=sa.astype("s")

    #Writes long array, initializing file (append=0)
    exe.WriteImage({},la,0,"")
    
    sys.exit()
    
    #Appends short array with new header items
    exe.WriteImage({'Name': 'Alexandre', 'Date': '16/07/2001'},sa)    

    #Appends short array, in Edf type unsigned
    exe.WriteImage({},sa,DataType="UnsignedShort")    

    #Appends short array, in Edf type unsigned
    exe.WriteImage({},sa,DataType="UnsignedLong")    

    #Appends long array as a double, considering unsigned
    exe.WriteImage({},la,DataType="DoubleValue",WriteAsUnsigened=1)

    #Gets unsigned short data, storing in an signed long
    ushort=exe.GetData(2,"SignedLong")

    #Makes an operation
    ushort=ushort-0x10

    #Saves Result as signed long
    exe.WriteImage({},ushort)

    #Saves in the original format (unsigned short)
    OldHeader=exe.GetHeader(2)
    exe.WriteImage({},ushort,1,OldHeader["DataType"] )

