import string
from PyDVT.ImageViewSelect import *
from PyDVT.ImageViewSelect import ImageViewSelect
from PyDVT.QtBinding import Drawable2D

DEBUG=0

class ViewSelectPolygon(ViewSelect):
  """
  Select a polygon
  """ 
  def __init__(self,data=None,callback=None):
  	ViewSelect.__init__(self,data,callback)
	self.polygon=[]
	
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    mouse_position=pos.DataCoord
    for view in self.ViewList.keys():   self.DrawTemp(view,mouse_position)

  def DoubleClick(self,pos):
    """
    Virtual: See ViewSelect
    """
    if DEBUG: print 'double click'
    #self.Erase("ALL")
    #self.Selection={}
    if self.Selection!={}:
    	self.Selection={}
	self.polygon=[]	
    if len(self.polygon)>2:
    	self.polygon.append(self.polygon[0])
	self.Selection={"Polygon":self.polygon}
    	#for view in self.ViewList.keys(): self.DrawView(view)
    	self.Update("ALL")
    	if self.callback is not None: self.callback(self)

  def Press(self,pos):
    """
    Virtual: See ViewSelect
    """
    if DEBUG: print 'In Press'
    #self.Erase("ALL")
    #self.Selection={}
    if self.Selection!={}:
    	self.Selection={}
	self.polygon=[]	
    self.polygon.append(pos.DataCoord)
    if DEBUG:
    	for point in self.polygon: print point.PageCoord,
    for view in self.ViewList.keys(): self.DrawView(view)


  def Release(self,pos):
    """
    Virtual: See ViewSelect
    """
    if hasattr(self,"Begin")==0: return
    #self.SetSelectionPos((self.Begin,pos.DataCoord))


  def DrawView(self,view):
    	i=0
	if len(self.polygon)>1:
	    	while i < len(self.polygon)-1:
		       	start=view.DataCoord2ImageCoord(self.polygon[i])
    			end= view.DataCoord2ImageCoord(self.polygon[i+1])   
			if DEBUG: print start,end
			name="SelectDraw"+str(i)
    			if name not in self.ViewList[view].keys():
        			self.ViewList[view][name]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
				#self.ViewList[view][name]=view.Drawable.PutLine(start[0]+100, start[1], end[0]+100, end[1],self.Pen)
    			else:
        			#self.ViewList[view][name]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
        			view.Drawable.SetObjectCoords(self.ViewList[view][name], start[0], start[1], end[0], end[1])
			i=i+1


  def EraseView(self,view):		  
    	for key in self.ViewList[view].keys():
    		if str(key)[:10]=="SelectDraw" or str(key)=="TempDraw":
        		view.Drawable.EraseObject(self.ViewList[view][key])
        		del self.ViewList[view][key]
		

  def DrawTemp(self,view,mouse_position):
    """
    Virtual: See ViewSelectDefault
    """
    if self.Selection!={}: return
    if len(self.polygon):
    	start=view.DataCoord2ImageCoord(self.polygon[-1])
    	end=  view.DataCoord2ImageCoord(mouse_position)    
    	if "TempDraw" not in self.ViewList[view].keys():
        	self.ViewList[view]["TempDraw"]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
	else:
		view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start[0], start[1], end[0], end[1])


  def GetDataSelection(self):
    """
    Virtual: See ImageViewSelect
    """
    if "BoundingRect" not in self.Selection.keys(): return None
    begin=self.Selection["BoundingRect"][0]
    end=self.Selection["BoundingRect"][1]
    return DataSelection.LineSelection(self.Data,begin.PageCoord,end.PageCoord,end.PageIndex)    


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "Polygon"
    


############## Selection of several points to define the image centre ###################  

class ImageViewSelectMultiplePoints(ImageViewSelect):
  """
  Implements a multiple points selection
  """
  def __init__(self,data=None,callback=None):
    	if DEBUG: print 'In ImageViewSelectMultiplePoints.__init__......'
  	ImageViewSelect.__init__(self,data,callback)
	self.points=[]	
    	if self.Selection!={}:
    		self.Selection={}	

  def DoubleClick(self,pos):
    """
    Virtual: See ViewSelect
    """
    if DEBUG: print 'In ImageViewSelectMultiplePoints.DoubleClick......'
    if len(self.points)!=0:
    	self.Selection["Points"]=self.points
    	if self.callback is not None: 
		self.callback(self)
    self.Selection={}
    for view in self.ViewList.keys():   self.EraseSelection(view)

  def Press(self,pos):
    if DEBUG: print 'In ImageViewSelectMultiplePoints.Press......'
    self.points.append(pos.DataCoord)
    for view in self.ViewList.keys(): self.DrawView(view)

  def DrawView(self,view):
    	if DEBUG: print 'In ImageViewSelectMultiplePoints.DrawView......'
    	i=0
	if len(self.points)>0:
	    	while i < len(self.points):
		       	start=view.DataCoord2ImageCoord(self.points[i])  
			end=(start[0]+1,start[1]+1)
			name="Point"+str(i)
        		self.DrawOnePoint(view,name,start,end)
			#self.ViewList[view][name]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
			i=i+1

  def DrawOnePoint(self,view,name,start,end):
    if DEBUG: print 'In ImageViewSelectMultiplePoints.DrawOnePoint......'    
    crossLength=3*(end[1]-start[1])
    crossWidth=end[0]-start[0]
    upCrossStart=(start[0],start[1]-crossWidth-crossLength)
    upCrossEnd=(start[0]+crossWidth,start[1]-crossWidth)
    leftCrossStart=(start[0]-crossWidth-crossLength,start[1])
    leftCrossEnd=(start[0]-crossWidth,start[1]+crossWidth)
    bottomCrossStart=(start[0],start[1]+2*crossWidth)
    bottomCrossEnd=(start[0]+crossWidth,start[1]+2*crossWidth+crossLength)
    rightCrossStart=(start[0]+2*crossWidth,start[1])
    rightCrossEnd=(start[0]+2*crossWidth+crossLength,start[1]+crossWidth)

    if name+"_SelectDraw" not in self.ViewList[view].keys():
        self.ViewList[view][name+"_SelectDraw"]=view.Drawable.PutRectangle(start[0], start[1], end[0], end[1],self.Pen,self.Brush)
        self.ViewList[view][name+"_CrossUp"]=view.Drawable.PutRectangle(upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1],self.Pen,self.Brush)
        self.ViewList[view][name+"_CrossLeft"]=view.Drawable.PutRectangle(leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1],self.Pen,self.Brush)
        self.ViewList[view][name+"_CrossBottom"]=view.Drawable.PutRectangle(bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1],self.Pen,self.Brush)
        self.ViewList[view][name+"_CrossRight"]=view.Drawable.PutRectangle(rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1],self.Pen,self.Brush)
    else:     
        view.Drawable.SetObjectCoords(self.ViewList[view][name+"_SelectDraw"], start[0], start[1], end[0], end[1])
        view.Drawable.SetObjectCoords(self.ViewList[view][name+"_CrossUp"],upCrossStart[0], upCrossStart[1], upCrossEnd[0], upCrossEnd[1])
        view.Drawable.SetObjectCoords(self.ViewList[view][name+"_CrossLeft"],leftCrossStart[0], leftCrossStart[1], leftCrossEnd[0], leftCrossEnd[1])
        view.Drawable.SetObjectCoords(self.ViewList[view][name+"_CrossBottom"],bottomCrossStart[0], bottomCrossStart[1], bottomCrossEnd[0], bottomCrossEnd[1])
        view.Drawable.SetObjectCoords(self.ViewList[view][name+"_CrossRight"],rightCrossStart[0], rightCrossStart[1], rightCrossEnd[0], rightCrossEnd[1])


  def EraseSelection(self,view):
    if DEBUG: print 'In ImageViewSelectMultiplePoints.EraseSelection......'
    for draw in self.ViewList[view].keys():
    	if string.split(draw,'_')[-1] in ("SelectDraw","CrossUp","CrossLeft","CrossBottom","CrossRight"):
        	view.Drawable.EraseObject(self.ViewList[view][draw])
        	del self.ViewList[view][draw]

