"""
ParametersDialog.py
General class to display a dialog window 
with the parameters and the values contained in the input dictionnary.
Parameters:
- parent: parent window
- initial_parameters: dictionnary containing the names and the values of the variables
- title: title of the parameters dialog window
- labelSize: size of the labels
- sizeX, sizeY: total size of the window
"""

from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='24/02/2003'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'


class ParametersDialog(QMainWindow):
	"""
    	ParametersDialog.py
    	General class to display a dialog window 
    	with the parameters and the values contained in the input dictionnary.
	Parameters:
	- parent: parent window
	- initial_parameters: dictionnary containing the names and the values of the variables
	- title: title of the parameters dialog window
	- labelSize: size of the labels
	- sizeX, sizeY: total size of the window
	"""
	def __init__(self, parent,initial_parameters,title="Parameters Dialog",labelSize=120,sizeX=210,sizeY=100):
        	QMainWindow.__init__(self,parent,"Tracking Parameters Editor",0)  

		self.dlg=Dialog(self,title,1,0)
        	box=QVBox( self.dlg )
		varList=initial_parameters.keys()
		varList.sort()
		
		self.params={}
		self.eds={}
		for var in varList:
			self.params[var]=initial_parameters[var]
			box1 = QHBox( box )
        		lab=QLabel(box1)
        		self.eds[var]=QLineEdit(box1)
        		lab.setText(var)
	 		lab.setFixedWidth(labelSize)
        		self.eds[var].setText(QString(str(self.params[var])))
			self.eds[var].setFixedWidth(60)
		
        	OKbox = QHBox( box )
        	button=QPushButton(OKbox)
        	button.setText("OK")
		button.setFixedWidth(80)
		CancelButton=QPushButton(OKbox)
		CancelButton.setFixedWidth(80)
        	CancelButton.setText("Cancel")
		self.connect(button,SIGNAL("clicked()"),self.dlg.accept)
		self.connect(CancelButton,SIGNAL("clicked()"),self.dlg.reject)
		
        	box.resize( sizeX, sizeY )
		
        	if self.dlg.exec_loop():
			for var in self.params.keys():
				if str(self.eds[var].text())!='None': self.params[var]=float(str(self.eds[var].text()))
				else: self.params[var]=None

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=ParametersDialog(None,{'NbColumns':2,'ReducFactor':1})
    app.setMainWidget (win)
    app.exec_loop()

