from EdfFileData import EdfFileData
from Py4datMLabPlugin import MLab

__date__='17/02/03'
__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'


class MLabEdfFileData(EdfFileData):
	def __init__(self,filename=None,refresh_interval=None,info={}):
		'''
		Easy Data Class to use in the command line
		MLabEdfFileData(filename)
		'''
		EdfFileData.__init__(self,refresh_interval,info)
		if filename!=None:
			self.SetSource(filename)
			self.LoadSource()
			print self.GetNumberPages()
	
	def display(self):
		import MLabData
		mldata=MLabData.MLabData(self.GetPageArray(0))
		MLab.newWindow(mldata)
		
	def applyFilter(self,filterName,pars={}):
		'''
		Allows to apply easily an existing filter to a data object
		without taking care of the selection and colormap filters
		'''
		import DataSelection
		sel=DataSelection.RectSelection(self)
		import ImageView
		colormap=ImageView.ColormapFilter(None,sel)
		print filterName, type(filterName)
		exec("from "+filterName+" import "+filterName+" as filter")
		import sys
		print filter, type(filter)
		filteredData=filter(colormap,pars=pars)
		return filteredData
	
	
	def displayFilteredImage(self,filter):
		data=self.applyFilter(filter)
		import MLabData
		mldata=MLabData.MLabData(data)
		MLab.newWindow(mldata)
		
	
		
		
if __name__=='__main__':
	data=MLabEdfFileData('../circle.edf')
