"""
    MLabRead.py
"""

import os, re, string
import EdfFileData
import MccdFileData
import DataSelection

__version__='1.0.0'
__date__=  '18/03/03'
__author__ =  'Anne-Cecile Gendrin'
    
DEBUG=0

def MLabRead(directory='.', fileList=None, regexp=None, fileType=None, maxFileNumber=None, pos=None, size=None):
	"""
	MLabRead function allows to read one or several files (format edf or Mccd) 
	and returns a dictionnary with filenames as keys and data selection objects as values. 
	One can select the files eather by a list of filenames, 
	or a string defining all the files to read (ex: '*ccd').
	Parameters:
	- directory: directory where to find the files
	- fileList: a list of string corresponding to the names of the files
	- regexp: a regular expression defining all the files to read (ex: '*ccd') 
	- fileType: an extension defining the fileType of files (ex: 'EDF')
	- maxFileNumber: an integer to limit the number of files to read.
	- pos, size: 2 tuples defining a rectangle to limit the loading to a region of the images
	"""
	DataDict={}
	if pos!=None and size!=None: 
		DataDict['pos']=pos
		DataDict['size']=size
	
	if os.path.exists(directory)==0: 
		print 'Specified path does not exist'
		return None
	
	if os.path.isdir(directory)==0: 
		print 'Specified directory is not a directory'
		return None
	
	if DEBUG: print os.listdir(directory)
	
	if fileList == None and regexp!=0:
		fileList=os.listdir(directory)
		newFileList=[]
		for element in fileList:
			if DEBUG: print element
			if os.path.isfile(os.path.join(directory,element))!=0 and re.match(regexp,element)!=None: 
				if DEBUG: print 'good element'
				newFileList.append(element)
		if DEBUG: print newFileList
		fileList=newFileList
		if maxFileNumber!=None: fileList=fileList[0:int(maxFileNumber)]
		print 'Number of files:', len(fileList)
	
	if fileType!=None: fileType=string.upper(fileType)
	elif fileList[0][-3:]=='edf': fileType="EDF"
	elif fileList[0][-4:]=='mccd': fileType="MCCD"
	elif fileList[0][-3:]=='jpg' or fileList[0][-4:]=='jpeg': fileType="JPG"
	elif fileList[0][-3:]=='gif': fileType="GIF"
	elif fileList[0][-3:]=='bmp': fileType="BMP"
	elif fileList[0][-3:]=='png': fileType="PNG"
	else: 
		print 'MLabRead ERROR: Format not specified'
		return {}
		
	print 'Loading files...'
	for filename in fileList:
		print filename
		filepath=os.path.join(directory,filename)
		if fileType=="EDF":
			DataDict[filepath]=EdfFileData.EdfFileData()
		elif fileType=="MCCD":
			DataDict[filepath]=MccdFileData.MccdFileData()
		elif (fileType=="JPG" or fileType=="GIF" or fileType=="BMP" or fileType=="PNG"):
			DataDict[filepath]=ImageFileData.ImageFileData()
		else: 
			print 'MLabRead ERROR: Format not supported'
			return {}
		DataDict[filepath].SetSource(filepath)
		if pos!=None and size!=None: DataDict[filepath].LoadSource(pos=pos, size=size)
		else: DataDict[filepath].LoadSource()		
	
	return DataDict
