"""
    MLabApplyFilter.py
"""

__version__='1.0.0'
__date__=  '19/03/03'
__author__ =  'Anne-Cecile Gendrin'

import DataSelection

DEBUG=1

def MLabApplyFilter(filter=None,dataDict=None,synchronized=1,buffer_input=0):
	"""
	MLabFilter allows to apply a filter on a dictionnary where the values
	are DataSelection objects.
	Parameters:
	filter: filter class
	dataDict=input dictionnary with file paths as keys and corresponding 
		DataSelection objects as values
	synchronized, buffer_input: see Filter class
	"""
	if DEBUG: print 'Apply filter...'
	if dataDict==None or filter==None: return
	resultDict={}
	if dataDict.has_key('pos'): resultDict['pos']=dataDict['pos']
	if dataDict.has_key('size'): resultDict['size']=dataDict['size']
	for key in dataDict.keys():
		if key!='pos' and key!='size':
			print key
			sel=DataSelection.RectSelection(dataDict[key])
			resultDict[key]=filter(sel,synchronized,buffer_input)
	return resultDict
	
