import saxs,array
from scidxp.util import *
from Numeric import *
import ReadEdfFile
from Py4datDisplay import *
from Py4datGraphView import *
import AzimInt


class IntegrationDataSetNode(DefaultDataSetNode):

	def __init__(self,dataSetNode):
		DefaultDataSetNode.__init__(self, "image", DefaultArray([0]))

		image=dataSetNode.getData().getData()
		roi_name = "none"
      
		print "image.shape: ", image.shape
		xsize,ysize = image.shape[0],image.shape[1]
		#print "xsize, ysize: ", xsize, ysize
      
		attributes=dataSetNode.getAttributes()
		print 'attributes=',attributes
		if attributes=={}: print 'Input DataSetNode does not have 3 rois as attributes'
		elif len(attributes.keys())!=3: print 'You must select 3 rois before integrate !'
		else:
			rois = attributes
			#for roi_name in rois.keys():
				#roi = rois[roi_name]
			ROI = Numeric.array([0])
			BKG1 = Numeric.array([0])
			BKG2 = Numeric.array([0])
				#output_roi = DefaultDataSetNode(roi_name, DefaultArray([0]))
			if "ROI1" in rois.keys():
				#y1, y2 = eval(rois["ROI1"].__repr__())[0],eval(rois["ROI1"].__repr__())[1]
				y1, y2 = rois["ROI1"][0],rois["ROI1"][1]
				if (y1 >= 0) and (y1 <= ysize) and (y2 >= 0) and (y2 <= ysize):
					ROI = Numeric.sum(image[:,int(y1):int(y2)],1)
					#output_roi.setAttribute("ROI1", roi_attributes["ROI1"])
			if "ROI0" in rois.keys():
				#y3, y4 = eval(rois["ROI0"].__repr__())[0],eval(rois["ROI0"].__repr__())[1]
				y3, y4 =rois["ROI0"][0],rois["ROI0"][1]
				if (y3 >= 0) and (y3 <= ysize) and (y4 >= 0) and (y4 <= ysize):
					BKG1 = Numeric.sum(image[:,int(y3):int(y4)],1)
					#output_roi.setAttribute("ROI2", roi_attributes["ROI2"])
			if "ROI2" in rois.keys():
				#y5, y6 = eval(rois["ROI2"].__repr__())[0],eval(rois["ROI2"].__repr__())[1]
				y5, y6 = rois["ROI2"][0],rois["ROI2"][1]
				if (y5 >= 0) and (y6 <= ysize) and (y5 >= 0) and (y6 <= ysize):
					BKG2 = Numeric.sum(image[:,int(y5):int(y6)],1)
					#output_roi.setAttribute("BKG2", roi_attributes["BKG2"])
			if len(BKG1) == len(BKG2):
				BKG = BKG1 + BKG2
  			else:
          			BKG = BKG1
			integrated_value = ROI - BKG
			self._array=DefaultArray(integrated_value)


	
def test():
	node = ReadEdfFile.ReadEdfFileGroupNode('test.edf')
	print node.getName()
	Image1 = node.getChild("Image1")
	print Image1.getData().getData().shape
	#print 'attributes=',Image1.getAttributes()

	IntDataSetNode=IntegrationDataSetNode(Image1)
	print IntDataSetNode.getData().getData().shape
	
	Py4datDisplay(IntDataSetNode)

def test2():
	node = ReadEdfFile.ReadEdfFileGroupNode('data/jj2_matlab.edf')
	print node.getName()
	Image1 = node.getChild("Image1")
	print Image1.getData().getData().shape
	print 'attributes=',Image1.getAttributes()
	
	AzimIntDataSetNode=AzimInt.AzimIntDataSetNode(Image1)
	Py4datDisplay(AzimIntDataSetNode)
	
	ROIGroupNode=DefaultGroupNode('ROIs')
	ROI1DataSetNode=DefaultDataSetNode('ROI1',[0])
	ROI2DataSetNode=DefaultDataSetNode('ROI2',[0])
	ROI3DataSetNode=DefaultDataSetNode('ROI3',[0])
	ROIGroupNode.insertChild(ROI1DataSetNode)
	ROIGroupNode.insertChild(ROI2DataSetNode)
	ROIGroupNode.insertChild(ROI3DataSetNode)

	ROI1DataSetNode.setAttribute("ROI", [100,110])
	ROI1DataSetNode.setAttribute("BKG1", [90,100])
	ROI1DataSetNode.setAttribute("BKG2",[110,120])

	ROI2DataSetNode.setAttribute("ROI",[200,210])
	ROI2DataSetNode.setAttribute("BKG1",[190,200])
	ROI2DataSetNode.setAttribute("BKG2",[210,220])

	ROI3DataSetNode.setAttribute("ROI",[300,310])
	ROI3DataSetNode.setAttribute("BKG1",[290,300])
	ROI3DataSetNode.setAttribute("BKG2",[310,320])

	print [ROI1DataSetNode.getAttributes()]

	IntDataSetNode=IntegrationDataSetNode(AzimIntDataSetNode)
	print IntDataSetNode.getData().getData().shape
	
	Py4datDisplay(IntDataSetNode)
   
if __name__=='__main__':
	test()
