import qt,saxs,array,types
from Numeric import *
from PyDVT.ExtendedImageView import *
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import ReadEdfFile
import PyDVT.ImageView
import PyDVT.GraphView as GraphView

DEBUG=0

class IntegrateQFilter(GraphFilter):
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=0,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none",pixelsize=(0.01,0.01),wavelength=1000,distance=50000):
		if DEBUG: print 'In IntegrateQFilter.__init__()'
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
		self.distance=distance
		self.wavelength=wavelength
		self.pixelsize=pixelsize
	
	def GetOutput(self):
		if DEBUG: print 'In IntegrateQFilter.GetOutput...'
		
		sel=self.GetInput()
		
		#print 'input=',sel['data'][0,0]
		image=sel['data']		
		if type(image)==types.NoneType: return
		
		outputGraph=[]
		for x in range(0,image.shape[1]):
          		outputGraph.append(Numeric.sum(image[:,x]))
			
		L=self.distance				# Distance echantillon-detecteur en um ?
		lo=self.wavelength			# Longeur d'onde en pico ???
		px=self.pixelsize[0]*10000		# Pixel size in um
		
		if DEBUG: print 'DEBUG',px,L,lo
		#py=100					# Pixel size in um
		i=0
		xaxis=[]
		while i<len(outputGraph):
			if type(outputGraph[0])!=types.FloatType:	outputGraph[i]=float(outputGraph[i])
			xaxis.append(i*px*2*math.pi/L/lo)		# SMALL ANGLE SCATTERING
			i=i+1
		outputarr=array(outputGraph)
      		xaxis=array(xaxis)
		if DEBUG: print 'DEBUG', max(xaxis)
		
		#print 'output=',outputarr[0:5]				
		return {'name': self.name,'data': outputarr,'xdata': xaxis,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
	
