"""
IntegratePhiFilter.py
Filter which does the azymuthal integration.
"""

import qt,saxs,array
from Numeric import *
from PyDVT.ExtendedImageView import *
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import PyDVT.ImageView as ImageView
import PyDVT.GraphView as GraphView
from ErrorWindow import ErrorWindow

DEBUG=0

class IntegratePhiFilter(GraphFilter):
	"""
	IntegratePhiFilter.py
	Filter which does the azymuthal integration.
	"""
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=1,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none",ROIx=None,ROIy=None,dict={}):
		"""
		Parameters:
		- name, source, synchronized, buffer_input, yscale, xdata, pen, symbol: 
			see PyDVT.GraphView.GraphFilter
		- ROIx, ROIy: tuples of values corresponding to the Region Of Interest
		- dict: dictionnary corresponding to the output of AzimIntFilter in order to avoid redundant calculations
		"""
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
		self.ROIx, self.ROIy=ROIx, ROIy
		self.dict=dict
	
	def GetOutput(self):
		if DEBUG: print 'In IntegratePhiFilter.GetOutput...'
		
		if self.dict=={}: sel=self.GetInput()
		else: sel=self.dict
		
		image=sel['data']	
			
          	x1, x2 = self.ROIx[0],self.ROIx[1]
		y1, y2 = self.ROIy[0],self.ROIy[1]
          	
		ROI = Numeric.sum(image[int(y1):int(y2),int(x1):int(x2)],1)
		integrated_arr = ROI
			
		self.xdata=arange(y1,y1+integrated_arr.shape[0],1)			
		return {'name': self.name,'data': integrated_arr,'xdata': self.xdata,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
			
		
	
