"""
FindMaxFilter.py
"""

from Numeric import *
from PyDVT.Filter import Filter
import DataSelection

__version__='1.0.0'
__date__=  '19/03/03'
__author__ =  'Anne-Cecile Gendrin'

DEBUG=0

class FindMaxFilter(Filter):
	"""
	Filter that returns the maxValue of the source data and its coordinates.
	Output: {maxValue, maxCoordX, maxCoordY}
	"""
	def __init__(self,source,synchronized=1,buffer_input=0):
		Filter.__init__(self,source,synchronized,buffer_input)
		print source
		print source.GetOutput()['data'].shape
	
	def GetOutput(self):
		if DEBUG: print 'In FindMaxFilter.GetOuput...'		
		sel=self.GetInput()
		data=sel['data']
		
		l=ravel(data).tolist()
		maxValue=max(l)
		n=l.count(maxValue)
		if n!=1: return {'maxValue':maxValue, 'maxCoordX':'several occurances', 'maxCoordY':'several occurances'}
		
		i=l.index(maxValue)
		maxCoordY=i/data.shape[0]
		maxCoordX=i-int(maxCoordY)*data.shape[0]
		if (maxCoordY-int(maxCoordY))!=0:
			maxCoordY=int(maxCoordY)+1
		
		print maxValue
		return {'maxValue':maxValue, 'maxCoordX':maxCoordX, 'maxCoordY':maxCoordY}
