from PyDVT.Data import *
from scidxp.util import DefaultGroupNode, DefaultDataSetNode
from ReadEdfFile import *
from ReadSpecFile import ReadSpecFileGroupNode


class DataToGroupNode(DefaultGroupNode):
	def __init__(self,data,GroupNodeName):		
		DefaultGroupNode.__init__(self,GroupNodeName)
		
		infoDico=data.GetInfo()
		print infoDico
		for info in infoDico.keys():
			self.setAttribute(info,infoDico[info])
		
		nbPages=data.GetNumberPages()
		print nbPages
		i=0
		while i<nbPages:
			DataSetNode=DefaultDataSetNode('page'+str(i),data.GetPageArray(index=i))
			infoPage=data.GetPageInfo(index=i)
			for info in infoPage.keys():
				DataSetNode.setAttribute(info,infoPage[info])
			self.insertChild(DataSetNode)
			i=i+1
		
		
class GroupNodeToData(Data):
	def __init__(self,GroupNode):
		infoDico=GroupNode.getAttributes()
		Data.__init__(self,refresh_interval=None,info=infoDico)
		
		self.Pages=[]
				
		nbDataSet=len(GroupNode.getChildren().keys())
		i=0
		while i<nbDataSet:
			DataSetNode=GroupNode.getChild(GroupNode.getChildren().keys()[i])
			arr=DataSetNode.getData().getData()
			infoPage=DataSetNode.getAttributes()
			self.AppendPage(info=infoPage,array=arr)
			i=i+1
			
if __name__=='__main__':
	groupNode = ReadSpecFileGroupNode('ll.spec', start_scan=69, end_scan=69).getChild('scan69')
	print '\nInitial GroupNode:', groupNode.getName()
	print 'Attributes:', groupNode.getAttributes().keys()
	print 'Children:',groupNode.getChildren().keys()
	
	blissData=GroupNodeToData(groupNode)
	print '\nBliss data:\nNumber of pages:',blissData.GetNumberPages()
	print 'Global Info:',blissData.GetInfo().keys()
	print 'First Page Dimension:', blissData.GetPageDimention(0)
	print 'First Page size:', blissData.GetPageSize(0)
	#print 'First Page Array:',blissData.GetPageArray(0)
	print 'First Page Info:',blissData.GetPageInfo(0).keys()
	
	outputGroupNode=DataToGroupNode(blissData,'name')
	print '\nBack to Scisoft:\nGroupNode:', groupNode.getName()
	print 'Attributes:',groupNode.getAttributes().keys()
	
