#!/usr/bin/env python

import os, string, Tkinter as Tk, dialogbox

class PageSetupDlg(dialogbox.MyDialog):

  def __init__(self, prndlg, **args):
    if not args.has_key('title'):
      args = args.copy()
      args['title'] = 'Page setup'

    self.prndlg = prndlg
    self.prnconf = prndlg.prnconf

    self.type = Tk.StringVar()
    self.type.set(self.prnconf.pgtype)

    pgwidth, pgheight = self.prnconf.pgsize
    cback = self.set_personal
    self.wentry = dialogbox.NumEntry(double = 1, format = '%.1f', 
				     callback = cback, val = pgwidth, 
				     range = (50, 1000))
    self.hentry = dialogbox.NumEntry(double = 1, format = '%.1f', 
				     callback = cback, val = pgheight, 
				     range = (50, 1000))
    self.update_nr()

    self.landscape = Tk.IntVar()
    self.landscape.set(self.prnconf.pglandscape)

    self.pgbd = []
    for val in self.prnconf.pgborders:
      entry = dialogbox.NumEntry(double = 1, format = '%.1f', 
				 val = val, range = (5, 500)) 
      self.pgbd.append(entry)

    self.color = Tk.IntVar()
    self.color.set(PrintConfig.colormodes.index(self.prnconf.colormode))
 
    apply(dialogbox.MyDialog.__init__, (self, prndlg), args)

  def body(self):
    # ------------------------ First frame -------------
    fm = self.get_frame()

    lb = Tk.Label(fm, text = 'Paper size:')
    lb.grid(row = 0, column = 0, columnspan = 2, sticky = Tk.W)

    sizes = PrintConfig.pagedim.keys()
    for elem in range(len(sizes)):
      type = sizes[elem]
      rb = Tk.Radiobutton(fm, text = type, variable = self.type, 
			  value = type, command = self.update_nr)
      rb.grid(row = elem % 3 + 1, column = elem / 3, sticky = Tk.W)

    fm.columnconfigure(1, pad = self.padx)

    col = 2
    rlist = [('Width', self.wentry), ('Height', self.hentry)]
    for i in range(2):
      lb = Tk.Label(fm, text = rlist[i][0])
      lb.grid(row = i + 1, column = col, sticky = Tk.W, padx = 5)

      var = rlist[i][1]
      var.create_entry(fm, width = 5)
      var.entry.grid(row = i + 1, column = col + 1)

      lb = Tk.Label(fm, text = 'mm')
      lb.grid(row = i + 1, column = col + 2, sticky = Tk.W)

    fm.columnconfigure(4, pad = 2 * self.padx)

    col = 5
    lb = Tk.Label(fm, text = 'Paper orientation:')
    lb.grid(row = 0, column = col, sticky = Tk.W)

    for val, text in [(0, 'Portrait'), (1, 'Landscape')]:
      rb = Tk.Radiobutton(fm, text = text, variable = self.landscape, 
			  value = val)
      rb.grid(row = val + 1, column = col, sticky = Tk.W)

    #------------------------- Second frame -------------
    fm = self.get_frame(multicolumn = 1)

    col = 0
    lb = Tk.Label(fm, text = 'Borders:')
    lb.grid(row = 0, column = col, sticky = Tk.W, columnspan = 6)

    llist = ('Up', 'Down', 'Left', 'Right')
    for i in range(4):
      row = i % 2 + 1
      col = col + ((i == 2) * 3)
      lb = Tk.Label(fm, text = llist[i])
      lb.grid(row = row, column = col, sticky = Tk.W, padx = 5)

      self.pgbd[i].create_entry(fm, width = 5)
      self.pgbd[i].entry.grid(row = row, column = col + 1)

      lb = Tk.Label(fm, text = 'mm')
      lb.grid(row = row, column = col + 2, sticky = Tk.W)

      fm.columnconfigure(col + 2, pad = self.padx / 2)

    #------------------------- Third frame -------------
    fm = self.get_frame(multicolumn = 1)

    col = 0
    cmodes = PrintConfig.colormodes
    lb = Tk.Label(fm, text = 'Color mode:')
    lb.grid(row = 0, column = col, sticky = Tk.W)
    for i in range(len(cmodes)):
      rb = Tk.Radiobutton(fm, text = string.capitalize(cmodes[i]), 
                          variable = self.color, value = i)
      rb.grid(row = i + 1, column = col, sticky = Tk.W)

    self.usrbody(self.prnconf.childstc)
        
  def usrbody(self, usrdict):
    pass

  def update_nr(self):
    if self.type.get() != 'Personal': 
      pgwidth, pgheight = PrintConfig.pagedim[self.type.get()]
      self.wentry.set(pgwidth)
      self.hentry.set(pgheight)

  def set_personal(self, *args):
    self.type.set('Personal')

  def validate(self):
    if ((self.pgbd[0].get() + self.pgbd[1].get() >= self.hentry.get()) or
        (self.pgbd[2].get() + self.pgbd[3].get() >= self.wentry.get())):
      tkMessageBox.showinfo("Page Setup", "Printing borders are too big")
      return 0

    return 1

  def apply(self):
    self.prnconf.pgtype = self.type.get()
    self.prnconf.pgsize = [self.wentry.get(), self.hentry.get()]
    self.prnconf.pglandscape = self.landscape.get()
    self.prnconf.colormode = PrintConfig.colormodes[self.color.get()]

    for i in range(4):
      self.prnconf.pgborders[i] = self.pgbd[i].get()

    self.usrapply(self.prnconf.childstc)

  def usrapply(self, usrdict):
    pass

class PrintDlg(dialogbox.MyDialog):
  
  nametext = ['Printer', 'File name']

  def __init__(self, master, prnconf, psdlgclass = PageSetupDlg, 
	       **args):
    args = args.copy()
    if not args.has_key('title'):
      args['title'] = 'Print'

    args['oktext'] = 'Print'
    args['btwidth'] = '8'
    self.usrbox = None
    self.psdlgclass = psdlgclass

    self.prnconf = prnconf
    self.file = Tk.IntVar()
    self.file.set(self.prnconf.file)
    self.fname = Tk.StringVar()
    self.fname.set(self.prnconf.fname)
    self.pname = Tk.StringVar()
    self.pname.set(self.prnconf.pname)

    apply(dialogbox.MyDialog.__init__, (self, master), args)


  def body(self):
    fm = self.get_frame()

    self.lb = Tk.Label(fm, text = PrintDlg.nametext[1])
    self.lb.grid(row = 0, column = 0, sticky = Tk.W)
    fm.columnconfigure(0, minsize = self.lb.winfo_reqwidth())

    self.nm = Tk.Entry(fm)
    self.nm.grid(row = 0, column = 1, padx = self.padx)
    self.setname()

    bt = Tk.Button(fm, text = 'Page Setup', command = self.do_pagesetup)
    bt.grid(row = 0, column = 2, sticky = Tk.EW)

    self.cb = Tk.Checkbutton(fm, text = 'Write to a file', 
				  command = self.setname, variable = self.file)
    self.cb.grid(row = 1, column = 0, columnspan = 2, sticky = Tk.W)

    bt = Tk.Button(fm, text = 'Preview', command = self.do_preview)
    bt.grid(row = 1, column = 2, sticky = Tk.EW)

    for row in range(2):
      fm.rowconfigure(row, pad = self.pady)

    self.usrbody(self.prnconf.childstc)

    return self.nm

  def usrbody(self, usrdict):
    pass

  def setname(self):
    self.lb.config(text = PrintDlg.nametext[self.file.get()])
    if self.file.get():
      var = self.fname
    else:
      var = self.pname

    self.nm.config(textvariable = var)

  def validate(self):
    return 1

  def apply(self):
    self.prnconf.file = self.file.get()
    if self.file.get():
      self.prnconf.fname = self.fname.get()
    else:
      self.prnconf.pname = self.pname.get()

    self.usrapply(self.prnconf.childstc)

  def usrapply(self, usrdict):
    pass

  def do_pagesetup(self):
    psdlg = self.psdlgclass(self, padx = self.padx, pady = self.pady, 
                            bd = self.bd, bdrelief = self.bdrelief)
    return psdlg.do_modal()

  def do_preview(self):
    self.ok(retcode = 2)

class PrintConfig:

  mm_in = 25.4
  pt_mm = 72 / mm_in

  pagedim = {'A3': (297,420), 'A4': (210,297), 'A5': (148.5,210), 
	     'Letter': (215.9,279.4), 'Legal': (215.9,355.6), 
	     'Personal': (0,0)}

  colormodes = ['mono', 'gray', 'color']

  def __init__(self):
    mmin = PrintConfig.mm_in

    self.file = 0
    self.fname = ''
    self.pname = os.getenv('PRINTER') or ''
    self.pgtype = 'A4' 
    self.pgsize = list(PrintConfig.pagedim[self.pgtype])
    self.pglandscape = 0
    self.pgborders = [mmin, mmin, mmin, mmin]
    self.colormode = PrintConfig.colormodes[1]

    self.childstc = {}

    self.prndlg = None
    self.prndlgact = 0


  def create_prndlg(self, master, dlgclass = PrintDlg, **args): 
    if self.prndlg != None: 
      return 
    
    self.prndlg = apply(dlgclass, (master, self), args) 


  def do_print_task(self, master, usr_prnfunct, **args):
    apply(self.do_prndlg_modal, (master,), args)
    if self.prndlgact == 0:
      return 0

    file = (self.file and self.prndlgact == 1)
    if file:
      fname = self.fname
    else:
      fname = self.get_tmp_filename()
    apply(usr_prnfunct, (self, fname))

    if not file:
      self.print_file(fname, preview = (self.prndlgact == 2))

    return self.prndlgact
    
  def do_prndlg_modal(self, master, dlgclass = PrintDlg, **args):
    if not self.prndlg:
      apply(self.create_prndlg, (master, dlgclass), args)

    self.prndlgact = self.prndlg.do_modal()
    self.prndlg = None
    return self.prndlgact

  def get_tmp_filename(self):
    from tempfile import *
    return mktemp()

  def print_file(self, fname, delete = 1, preview = 0):
    if preview:
      cmd = "gv -media %s %s" % (self.pgtype, fname)
      a = os.system(cmd)
      if a:
        print "trying ghostview"
        if self.pgtype [0] == 'A':
	    cmd = "ghostview -a%s %s" % (self.pgtype[1], fname)
        else:
            cmd = "ghostview %s" % fname 
        a = os.system(cmd)
        if a:
            print "Please install gv and/or ghostview on tour system"
      if delete:
        cmd = "sh -c \"%s; rm %s\" &" % (cmd, fname)
      else:
        cmd = cmd + " &"
    else:
      if os.uname()[0] == 'Linux':
        cmd = "lpr -d%s %s" % (self.pname, fname)
      else:
        cmd = "lp -c -d%s %s" % (self.pname, fname)
      os.system(cmd)
      if delete:
        os.remove(fname)

  

def prn_config_ask_print(rt):
  prnconf = PrintConfig()
  prnconf.do_prndlg_modal(rt)
  print prnconf.prndlgact


def prn_config_main():
  rt = Tk.Tk()
  fm = Tk.Frame(rt)
  fm.pack()

  def myprint(master = rt):
    prn_config_ask_print(master)

  bt = Tk.Button(fm, text = 'Print', command = myprint)
  bt.pack()
  rt.mainloop()


if __name__ == '__main__':
  prn_config_main()
