import sys
from qt import *
import qttable
import string

DEBUG=0

class QComboTableItem(qttable.QTableItem):
    def __init__(self, table, list):
        qttable.QTableItem.__init__(self,table,qttable.QTableItem.Always,"")
        self.setReplaceable(0)
        self.cb=QComboBox(table.viewport())
        self.list=list
        self.cb.insertStringList(list)

    def setCurrentItem(self,cur):
        for i in range (len(self.list)):
            if cur==self.list[i]:
                self.cb.setCurrentItem(i)
                return
        
    def paint(self,p, cg, cr, selected):
        #self.cb.setGeometry(cr)
        #self.cb.show()


        fakeCombo->resize( cr.width(), cr.height() );

        #QColorGroup c( cg );
        #if ( selected ) {
        #c.setBrush( QColorGroup::Base, cg.brush( QColorGroup::Highlight ) );
        #c.setColor( QColorGroup::Text, cg.highlightedText() );
        #}

        table()->style().drawComplexControl( QStyle::CC_ComboBox, p, fakeCombo, fakeCombo->rect(), c );

        p->save();
        QRect textR = table()->style().querySubControlMetrics(QStyle::CC_ComboBox, fakeCombo,
                                 QStyle::SC_ComboBoxEditField);
        p->drawText( textR, wordWrap() ? ( alignment() | WordBreak ) : alignment(), *entries.at( current ) );
        p->restore();    
        
class Parameters(qttable.QTable):
    def __init__(self, *args,**kw):
        apply(qttable.QTable.__init__, (self, ) + args)
        self.setNumRows(1)
        self.setNumCols(1)
        self.labels=['Parameter','Estimation','Fit Value','Sigma',
                     'Restrains','Min/Parame','Max/Factor/Delta/']
        self.code_options=["FREE","POSITIVE","QUOTED",
                 "FIXED","FACTOR","DELTA","SUM","IGNORE","ADD","SHOW"]

        self.setNumCols(len(self.labels))
        i=0
        for label in kw['labels']:
            QHeader.setLabel(self.horizontalHeader(),i,label)
            i=i+1
        self.parameters={}
        self.paramlist=[]
        if kw.has_key('paramlist'):
            self.paramlist = kw['paramlist']
        self.build()
        self.connect(self,SIGNAL("valueChanged(int,int)"),self.myslot)

    def build(self):
        line = 1
        oldlist=list(self.paramlist)
        self.paramlist=[]
        for param in oldlist:
            self.newparameterline(param,line)
            line=line+1

    def newparameterline(self,param,line):
        #get current number of lines
        nlines=self.numRows()
        #print "nlines =",nlines
        #if the number of lines is smaller than line resize table
        if (line > nlines):
            self.setNumRows(line)
        #self.show()
        #fill the line
        linew=line-1
        self.parameters[param]={'line':linew,
                                'fields':['name',
                                          'estimation',
                                          'fitresult',
                                          'sigma',
                                          'code',
                                          'val1',
                                          'val2'],
                                'estimation':QString('0'),          
                                'fitresult':QString(),
                                'sigma':QString(),
                                'code':QString('FREE'),
                                'val1':QString(),
                                'val2':QString(),
                                'cons1':0,
                                'cons2':0,
                                'vmin':QString('0'),
                                'vmax':QString('1'),
                                'relatedto':QString(),
                                'factor':QString('1.0'),
                                'delta':QString('0.0'),
                                'sum':QString('0.0'),
                                'group':QString(),
                                'name':QString(param)}
        self.paramlist.append(param)
        self.setText(linew,0,QString(param))
        self.setReadWrite(param,'estimation')
        self.setReadOnly(param,['fitresult','sigma','val1','val2'])

        #the code
        a=QStringList()
        for option in self.code_options:
            a.append(option)
        ###
        self.parameters[param]['code_item']=qttable.QComboTableItem(self,a)
        ###self.parameters[param]['code_item']=QComboTableItem(self,a)
        self.setItem(linew,
                     self.parameters[param]['fields'].index('code'),
                     self.parameters[param]['code_item'])
        self.parameters[param]['relatedto_item']=None
        ###
        if qVersion()>="3.0.0":
            self.setColumnReadOnly(self.parameters[param]['fields'].index('name'),1)
            self.setColumnReadOnly(self.parameters[param]['fields'].index('fitresult'),1)
            self.setColumnReadOnly(self.parameters[param]['fields'].index('sigma'),1)

    def fillfromfit(self,fitparameterslist):
        self.parameters={}
        self.paramlist=[]
        line=1
        for param in fitparameterslist:
            self.newparameterline(param['name'],line)
            line=line+1
        for param in fitparameterslist:
            name=param['name']
            code=param['code']
            val1=param['cons1']
            val2=param['cons2']
            estimation=param['estimation']
            group=param['group']
            fitresult=param['fitresult']
            self.configure(name=name,
                           code=param['code'],
                           val1=val1,val2=val2,
                           estimation=estimation,
                           fitresult=fitresult,
                           group=group)


    def myslot(self,row,col):
        if DEBUG:
            print "Passing by myslot"        
        param=self.paramlist[row]
        field=self.parameters[param]['fields'][col]
        oldvalue=QString(self.parameters[param][field])
        newvalue=QString(self.text(row,col))
        if DEBUG:
            print "old value = ",oldvalue
            print "new value = ",newvalue
        if self.validate(param,field,oldvalue,newvalue):
            #self.parameters[param][field]=newvalue
            if DEBUG:
                print "Change is valid"
            exec("self.configure(name=param,%s=newvalue)" % field)
        else:
            if DEBUG:
                print "Change is not valid"
            if field == 'code':
                self.parameters[param]['code_item'].setCurrentItem(oldvalue)
            else:
                #self.setText(row,col,oldvalue)
                exec("self.configure(name=param,%s=oldvalue)" % field)
    
    def validate(self,param,field,oldvalue,newvalue):
        if field == 'code':
            pass
            return self.setcodevalue(param,field,oldvalue,newvalue)
        if ((str(self.parameters[param]['code']) == 'DELTA') or\
            (str(self.parameters[param]['code']) == 'FACTOR') or\
            (str(self.parameters[param]['code']) == 'SUM')) and \
            (field == 'val1'):
                best,candidates=self.getrelatedcandidates(param)
                if str(newvalue) in candidates:
                    return 1
                else:
                    return 0
        else:
            try:
                string.atof(str(newvalue))
            except:
                return 0
        return 1

    def setcodevalue(self,workparam,field,oldvalue,newvalue):
        if   str(newvalue) == 'FREE':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')                          
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'POSITIVE':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'QUOTED':
            #I have to get the limits
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=self.parameters[workparam]['vmin'],
                           #cons2=self.parameters[workparam]['vmax'])
                           #,
                           #val1=self.parameters[workparam]['vmin'],
                           #val2=self.parameters[workparam]['vmax'])
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'FIXED':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'FACTOR':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)    
            return 1
        elif str(newvalue) == 'DELTA':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'SUM':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'IGNORE':
            # I should check if the group can be ignored
            # for the time being I just fix all of them to ignore
            group=int(str(self.parameters[workparam]['group']))
            candidates = []
            for param in self.parameters.keys():
                if group == int(str(self.parameters[param] ['group'])):
                    candidates.append(param)
            #print candidates 
            #I should check here if there is any relation to them
            for param in candidates:
                self.configure(name=param,
                               code=newvalue)
                               #,
                               #cons1=0,
                               #cons2=0,
                               #val1='',
                               #val2='')
            return 1
        elif str(newvalue) == 'ADD':
            group=int(str(self.parameters[workparam]['group']))
            if group == 0:
                #One cannot add a background group
                return 0
            i=0
            for param in self.paramlist:
                if i <=  int(str(self.parameters [param] ['group'])):
                    i = i + 1
            self.addgroup(i,group)
            return 0

        elif str(newvalue) == 'SHOW':
            print self.cget(workparam)
            return 0

        else:
            print "None of the others!"

    def addgroup(self,newg,gtype):
        line = 0
        newparam=[]
        oldparamlist=list(self.paramlist)
        for param in oldparamlist:
            line = line + 1
            paramgroup = int(str(self.parameters [param] ['group']))
            if paramgroup  == gtype:
                #Try to construct an appropriate name
                #I have to remove any possible trailing number
                #and append the group index
                j=len(param)-1
                while ('0' < param[j]) & (param[j] < '9'):
                    j=j-1
                    if j == -1:
                        break
                if j >= 0 :
                    newparam.append(param[0:j+1] + `newg`)
                else:
                    newparam.append(`newg`)
        for param in newparam:
            line=line+1
            self.newparameterline(param,line)
        for param in newparam:
            self.configure(name=param,group=newg)

    def freerestofgroup(self,workparam):
        if workparam in self.parameters.keys():
            group=int(str(self.parameters[workparam]['group']))
            for param in self.parameters.keys():
                if param != workparam:
                    if group == int(str(self.parameters[param]['group'])):
                        self.configure(name=param,
                                       code='FREE',
                                       cons1=0,
                                       cons2=0,
                                       val1='',
                                       val2='')
                                       
    def getrelatedcandidates(self,workparam):
        best=None
        candidates = []
        for param in self.paramlist:
            if param != workparam:
                if str(self.parameters[param]['code']) != 'IGNORE' and \
                   str(self.parameters[param]['code']) != 'FACTOR' and \
                   str(self.parameters[param]['code']) != 'DELTA'  and \
                   str(self.parameters[param]['code']) != 'SUM' :
                        candidates.append(param)
        #Now get the best from the list
        if candidates == None:
            return best,candidates
        #take the previous one if possible
        if str(self.parameters[workparam]['relatedto']) in candidates:
            best=str(self.parameters[workparam]['relatedto'])
            return best,candidates
        #take the first with similar name
        for param in candidates:
                j=len(param)-1
                while ('0' < param[j]) & (param[j] < '9'):
                    j=j-1
                    if j == -1:
                        break
                if j >= 0 :
                    try:
                        pos=string.index(workparam,param[0:j+1])
                        if pos == 0:
                            best=param
                            return best,candidates
                    except:
                        pass
        #take the first
        return candidates[0],candidates             

    def setReadOnly(self,parameter,fields):
        if DEBUG:
            print "parameter ",parameter,"fields = ",fields,"asked to be read only"
        self.setfield(parameter,fields,0)
        
    def setReadWrite(self,parameter,fields):
        if DEBUG:
            print "parameter ",parameter,"fields = ",fields,"asked to be read write"
        self.setfield(parameter,fields,1)
                            
    def setfield(self,parameter,fields,EditType):
        if DEBUG:
            print "setfield. parameter =",parameter,"fields = ",fields
        if type(parameter) == type (()) or \
           type(parameter) == type ([]):
            paramlist=parameter
        else:
            paramlist=[parameter]
        if type(fields) == type (()) or \
           type(fields) == type ([]):
            fieldlist=fields
        else:
            fieldlist=[fields]
        for param in paramlist:
            if param in self.paramlist:            
                try:
                    row=self.paramlist.index(param)
                except ValueError:
                    row=-1
                if row >= 0:
                    for field in fieldlist:
                        if field in self.parameters[param]['fields']:
                            col=self.parameters[param]['fields'].index(field)
                        if field != 'code':
                            key=field+"_item"
                            self.parameters[param][key]=qttable.QTableItem(self,EditType,
                                        self.parameters[param][field])
                            self.setItem(row,col,self.parameters[param][key])

    def configure(self,*vars,**kw):
        if DEBUG:
            print "configure called with **kw = ",kw
        name=None
        error=0
        if kw.has_key('name'):
            name=kw['name']
        else:
            return 1
        if self.parameters.has_key(name):
            row=self.parameters[name]['line']
            for key in kw.keys():
              if key is not 'name':
                if key in self.parameters[name]['fields']:
                    col=self.parameters[name]['fields'].index(key)
                    oldvalue=self.parameters[name][key]
                    newvalue=QString(str(kw[key]))
                    #avoid endless recursivity
                    if key is not 'code':
                        if self.validate(name,key,oldvalue,newvalue):
                            #self.setText(row,col,newvalue)
                            self.parameters[name][key]=newvalue
                        else:
                            #self.setText(row,col,oldvalue)
                            self.parameters[name][key]=oldvalue
                            error=1
                    #else:
                    #    self.parameters[name][key]=newvalue
                    #    self.parameters[name]['code_item'].setCurrentItem(newvalue)
                elif key in self.parameters[name].keys():
                    newvalue=QString(str(kw[key]))
                    self.parameters[name][key]=newvalue
                    #if key == 'relatedto':
                    #    self.parameters[name]['relatedto_item'].setCurrentItem(newvalue)    
            if DEBUG:
                print "error = ",error
            #if error == 0:
            if 1:
                if 'code' in kw.keys():
                    newvalue=QString(kw['code'])
                    self.parameters[name]['code']=newvalue
                    self.parameters[name]['code_item'].setCurrentItem(newvalue)
                    if str(self.parameters[name]['code']) == 'QUOTED':
                      if 'val1'in kw.keys():
                        self.parameters[name]['vmin']=self.parameters[name]['val1']
                      if 'val2'in kw.keys():
                        self.parameters[name]['vmax']=self.parameters[name]['val2']
                        #print "vmin =",str(self.parameters[name]['vmin'])
                    if str(self.parameters[name]['code']) == 'DELTA':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=kw['val1']
                          else:
                            self.parameters[name]['relatedto']=\
                                     self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['delta']=self.parameters[name]['val2']
                    if str(self.parameters[name]['code']) == 'SUM':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=kw['val1']
                          else:
                            self.parameters[name]['relatedto']=\
                                     self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['sum']=self.parameters[name]['val2']
                    if str(self.parameters[name]['code']) == 'FACTOR':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=kw['val1']
                          else:
                            self.parameters[name]['relatedto']=\
                                     self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['factor']=self.parameters[name]['val2']
                else:
                    #Update the proper parameter in case of change in val1 and val2
                    if str(self.parameters[name]['code']) == 'QUOTED':
                        self.parameters[name]['vmin']=self.parameters[name]['val1']
                        self.parameters[name]['vmax']=self.parameters[name]['val2']
                        #print "vmin =",str(self.parameters[name]['vmin'])
                    if str(self.parameters[name]['code']) == 'DELTA':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1']
                        self.parameters[name]['delta']=self.parameters[name]['val2']
                    if str(self.parameters[name]['code']) == 'SUM':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1']
                        self.parameters[name]['sum']=self.parameters[name]['val2']
                    if str(self.parameters[name]['code']) == 'FACTOR':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1']
                        self.parameters[name]['factor']=self.parameters[name]['val2']
         
            if(1):
                #Update val1 and val2 according to the parameters
                #and Update the table
                if str(self.parameters[name]['code']) == 'FREE' or \
                   str(self.parameters[name]['code']) == 'POSITIVE' or \
                   str(self.parameters[name]['code']) == 'IGNORE' or\
                   str(self.parameters[name]['code']) == 'FIXED' :
                    self.parameters[name]['val1']=QString()
                    self.parameters[name]['val2']=QString()                   
                    self.parameters[name]['cons1']=0                   
                    self.parameters[name]['cons2']=0                   
                    self.setReadWrite(name,'estimation')
                    self.setReadOnly(name,['fitresult','sigma','val1','val2'])
                elif str(self.parameters[name]['code']) == 'QUOTED':
                    self.parameters[name]['val1']=self.parameters[name]['vmin']
                    self.parameters[name]['val2']=self.parameters[name]['vmax']
                    try:
                        self.parameters[name]['cons1']=\
                            string.atof(str(self.parameters[name]['val1']))
                    except:
                        self.parameters[name]['cons1']=0
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2']))
                    except:
                        self.parameters[name]['cons2']=0
                    if self.parameters[name]['cons1'] > self.parameters[name]['cons2']:
                        buf=self.parameters[name]['cons1']
                        self.parameters[name]['cons1']=self.parameters[name]['cons2']
                        self.parameters[name]['cons2']=buf
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'FACTOR':
                    self.parameters[name]['val1']=self.parameters[name]['relatedto']
                    self.parameters[name]['val2']=self.parameters[name]['factor']
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1']))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2']))
                    except:
                        error=1
                        print "Forcing factor to 1" 
                        self.parameters[name]['cons2']=1.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'DELTA':
                    self.parameters[name]['val1']=self.parameters[name]['relatedto']
                    self.parameters[name]['val2']=self.parameters[name]['delta']
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1']))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2']))
                    except:
                        error=1
                        print "Forcing delta to 0" 
                        self.parameters[name]['cons2']=0.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'SUM':
                    self.parameters[name]['val1']=self.parameters[name]['relatedto']
                    self.parameters[name]['val2']=self.parameters[name]['delta']
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1']))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2']))
                    except:
                        error=1
                        print "Forcing sum to 0" 
                        self.parameters[name]['cons2']=0.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                else:
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])                                 
        return error
        
    def cget(self,param):
        """
        Return tuple estimation,constraints where estimation is the
        value in the estimate field and constraints are the relevant
        constraints according to the active code
        """
        estimation=None
        costraints=None
        if param in self.parameters.keys():
            buf=str(self.parameters[param]['estimation'])
            if len(buf):
                estimation=string.atof(buf)
            else:
                estimation=0
            self.parameters[param]['code_item']
            code = self.code_options.index(str(self.parameters[param]['code']))
            cons1=self.parameters[param]['cons1']
            cons2=self.parameters[param]['cons2']
            constraints = [code,cons1,cons2]
        return estimation,constraints 
                    
def main(args):
    app=QApplication(args)
    win=QMainWindow()
    tab=Parameters(labels=['Parameter','Estimation','Fit Value','Sigma',
                        'Restrains','Min/Parame','Max/Factor/Delta/'],
                   paramlist=['Height','Position','FWHM'])
    tab.showGrid()
    if (0):
        tab.setText(0,3,QString('Hello World!'))
        tab.setItem(0,1,qttable.QTableItem(tab,1,QString('a try')))
        check=qttable.QCheckTableItem(tab,QString("Check me!"))
        tab.setItem(0,2,check)
        a=QStringList()
        a.append("1")
        a.append("2")    
        checklist=qttable.QComboTableItem(tab,a)
        tab.setItem(0,0,checklist)
    tab.configure(name='Height',estimation='1234',group=0)    
    tab.configure(name='Position',code='FIXED',group=1)
    tab.configure(name='FWHM',group=1)
    #for item,value in tab.parameters['Position'].items():
    #    print item,value
    if 1:
        import specfile
        import NewSpecfit
        from Numeric import sqrt,equal,array,Float,concatenate,arange,take,nonzero
        sf=specfile.Specfile('02021201.dat')
        scan=sf.select('14')
        #sf=specfile.Specfile('02022101.dat')
        #scan=sf.select('11')
        nbmca=scan.nbmca()
        mcadata=scan.mca(1)
        y=array(mcadata)
        x=arange(len(y))
        #x=arange(len(y))*0.0200511-0.003186
        fit=NewSpecfit.Specfit()
        fit.setdata(x=x,y=y)
        fit.importfun("SpecfitFunctions.py")
        fit.settheory('Hypermet')
        fit.configure(Yscaling=1.,
                      WeightFlag=1,
                      PosFwhmFlag=1,
                      HeightAreaFlag=1,
                      FwhmPoints=50,
                      PositionFlag=1,
                      HypermetTails=1)        
        fit.setbackground('Linear')
        if 0:
            mcaresult=fit.mcafit(x=x,xmin=x[70],xmax=x[500])
        else:
            fit.estimate()
            fit.startfit()
        tab.fillfromfit(fit.paramlist)
    tab.show()
    app.connect(tab, SIGNAL("WindowClosed()"),app,SLOT("quit()"))
    app.connect(app, SIGNAL("lastWindowClosed()")
                                 , app
                                 , SLOT("quit()")
                                 )
    app.exec_loop()

if __name__=="__main__":
    main(sys.argv)	
