def test():
    import SpecfitFunctions
    import string
    from Numeric import sqrt,equal,array,Float,concatenate,arange
    from NewSpecfit import Specfit
    if (1):
        import specfile
        sf=specfile.Specfile('02021201.dat')
    	scan=sf.select('10')
        nbmca=scan.nbmca()
        mcadata=scan.mca(1)
        y=array(mcadata)
        x=arange(len(y))
    else:
        # build a spectrum array
        f=open("spec.arsp",'r')
        #read the spectrum datas
        x=array([],Float)
        y=array([],Float)
        tmp=f.readline()[:-1]
        while (tmp != ""):
            tmpSeq=tmp.split()
            x=concatenate((x,[float(tmpSeq[0])]))
            y=concatenate((y,[float(tmpSeq[1])]))
            tmp=f.readline()[:-1]
        
    # init fit
    fit=Specfit()
    fit.setdata(x=x,y=y)
    if (0):
        a=SpecfitFunctions.SpecfitFunctions()
        a.config['Yscaling']=2000.
        a.config['PosFwhmFlag']=1
        a.config['HeightAreaFlag']=1
        a.config['SameFwhmFlag']=1
        a.config['FwhmPoints']=20
        a.config['PositionFlag']=1
        fit.addtheory('Gaussians',a.gauss,['Height','Position','FWHM'],
                      a.estimate_gauss)
        fit.settheory('Gaussians')
    else:
        fit.importfun("SpecfitFunctions.py")
        #print fit.theorydict
        fit.settheory('Hypermet')
        #fit.settheory('Area Gaussians')
        fit.configure(Yscaling=1.,
                      WeightFlag=1,
                      PosFwhmFlag=1,
                      HeightAreaFlag=1,
                      FwhmPoints=50,
                      PositionFlag=1,
                      HypermetTails=5)
    if 1:
        fit.setbackground('Linear')
    else:
        fit.setbackground('Constant')
    if 0:
        fit.setbackground('Internal')
        fit.configure(HypermetTails=1)
    if (0):
        fit.estimate()
        #print fit.paramlist
        fit.startfit()
        #print fit.paramlist
    if(1):
        #mcaresult=fit.mcafit(yscaling=1.,fwhm=60,sensitivity=3.5)
        mcaresult=fit.mcafit(sensitivity=3.5)
        if mcaresult != []:
            print "POSITION        AREA          FWHM      CHISQ    XBEGIN   XEND"
            for result in mcaresult:
                if result['chisq'] is not None:
                    for param in result['paramlist']:
                        if string.find(param['name'],'Position') != -1:
                            pos="%8.2f " %  param['fitresult']
                        if string.find(param['name'],'Area')!= -1:
                            area="%12.5f   " %  param['fitresult']
                        if (string.find(param['name'],'FWHM') != -1) | \
                           (string.find(param['name'],'Fwhm') != -1) | \
                           (string.find(param['name'],'fwhm') != -1):
                            fwhm="%8.3f   " %  param['fitresult']
                            print "%s %s %s %f %8.2f %8.2f" % (pos,area,
                                                   fwhm,
                                                   result['chisq'],
                                                   result['xbegin'],
                                                   result['xend'])
                x=fit.xdata0[int(result['xbegin']):int(result['xend'])]
                y=fit.ydata0[int(result['xbegin']):int(result['xend'])]
                #yfit=fit.gendata(x=x,parameters=result['paramlist'])
                #SimplePlot.plot([x,y,yfit])
                #SimplePlot.plot([x,2500*(y-yfit)/(sqrt(y)+equal(y,0))])
    if 0:                               
      if fit.chisq != None:    
        print "Obtained parameters : "
        for param in fit.paramlist:
            print param['name'],' = ',param['fitresult']
        print "chisq = ",fit.chisq 
    
        # display result
        #root=Tkinter.Tk()
        app  = MyBlissgraph.Blissgraph(root)
        xs    = ['Equis', x]
        data  = ['Counts','Equis',y]
        data2 = ['Fit','Equis',fit.gendata()]
        
        app.setx(xs)
        app.sety(data)
        app.sety(data2)
        root.geometry("500x400+50+50")
        root.title("Blissgraph")

        app.pack(fill='both',expand='yes')
        root.mainloop()


if __name__ == "__main__":
    test()
