"""
    Drawable2D.py
    2D Image displaying widget
"""

from PyDVT import __version__,__date__,__author__


from Binding import Pen,Brush



class Drawable_2D:
    """
    2D Graphics displaying widget interface definition
    
    Application Level Interface:
    ===========================
    This class has some methods that can be called at application level. They refer to adding
    and changing graphical elements over the graphic displaying. They are called through
    View.GetDrawable() object:    
        PutLine
        PutRectangle
        SetObjectCoords
        EraseObject
        
    This class generates the following callbacks to parent (a View object):
        _RightButtonPress
        _ButtonPress
        _DoubleClick
        _ButtonRelease
        _Motion
        _ButtonPressMotion
        _KeyPress
    """
    def __init__(self,parent,zoom_mode="ON",scroll_mode="ON"):
        """
        Parameters:
            parent: parent widget (a View object)
            zoom_mode: "ON", "OFF" or "FIT_TO_SCREEN"
            scroll_mode: "ON" or "OFF"
        """
        pass                    

    def ViewCoord2ImageCoord(self,view_coord):
        """
        Tranforms view coordinates (as generated by the events) into
        image coordinates (referenced to original image)
        """
        pass                    

        
    def ImageCoord2ViewCoord(self,image_coord):
        """
        Tranforms image coordinates (referenced to original image) into        
        view coordinates (as generated by the events)
        """
        pass                    


    def Save(self,filename,format):
        """
        Parameters:
            filename: name of the output file.
            format: format to be saved ("PS","PNG","BMP" or "JPG")
        """
        pass                    


    def DrawImage(self,image_string,image_size,depth,colormap_table,reset_zoom=0):
        """
        Parameters:
            image_string: String with the image data
            image_size: tuple, size of the image (x,y).
            depth: either 32 (image_string has RGBX representation of image) or
                   8 (image has 256 levels of colors, 1 byte per pixel)
            colormap_table: only considered if depth equals to 8. In this case,
                            it is a list of 256 int numbers corresponding to
                            the RGB value for each color number.
            reset_zoom: if non-zero, resets zoom and scroll state.
        """
        pass                    


    def EraseImage(self):
        """
        """
        pass                    

        
    def SetZoom(self, val=None, rect=None, com=None):
        """
        Sets zoom state 
        Parameters: (only one must be set)
          val:  a float, sets directly a value to the zoom factor
          rect: a tuple in the format (x0,y0,x1,y1), that defines the coordinates of
                the upper-left and the lower-right points of a zoomed area, in
                image coordinates.
          com:  can be "fit", "normal", "in" and "out"
        """        
        pass                    


    def MoveTo(self,position):
        """
        Parameters:
            position: tuple (x,y), position (image coords) to scroll to
        """
        pass                    
        

    def PutLine(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid")):
        """
        Parameters:
            X0,Y0: First point (image coords)
            X1,Y1: Second point (image coords)
            pen: Pen object
        Returns a reference to the object
        """
        pass                    


    def PutRectangle(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid"),brush=Brush((0,0,0),"fill_0")):
        """
        Parameters:
            X0,Y0: upper-left corner (image coords)
            X1,Y1: lower-right corner (image coords)
            pen: Pen object to the contour
            brush: Brush object for the filling
        Returns a reference to the object
        """
        pass                    


    def SetObjectCoords(self,obj,*args):
        """
        Changes the coordinates of an graphical object
        Parameters:
            obj: reference to the object
            *args: X0,Y0,X1,Y1,... in image coords
        """
        pass                    


    def EraseObject(self,obj):
        """
        Erases graphical object
        Parameters:
            obj: reference to the object
        """
        pass                    

                           
    def Show(self):
        """
        Displays widget
        """
        pass                    


    def Destroy(self):
        """
        Cleanup
        """
        pass                    
       

    def GetWindowPosition(self):
        """
        Returns image coordinates of the visible upper left corner
        """
        pass                    


    def GetWindowHeight(self):
        """
        Returns the height of visible window
        """
        pass                    


    def GetWindowWidth(self):
        """
        Returns the width of visible window
        """
        pass                    


    def GetZoomFactor(self):
        """
        Returns zoom factor:
        - equals to 1. if no zoom
        - greater than 1. if zoomed in
        - less than 1. if zoomed out
        """
        pass                    


    def GetHeight(self):
        """
        Returns height of the displayed image (image coords)
        """
        pass                    


    def GetWidth(self):
        """
        Returns width of the displayed image (image coords)
        """
        pass                    
