"""
    FitDialog.py
    Fit filter parameters control dialog.
    
"""

__version__=  '1.0'
__date__ =    '01 June 2002'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


################################################################################
import qt
import EventHandler
import Command
from Binding import *
#from Parameters import Parameters
from MultiParameters import ParametersTab as Parameters

class FitParametersDialog(qt.QMainWindow):
    """
    """
    def __init__(self, parent,initial_parameters):
        self.Parameters=initial_parameters
        self.eh = None
        self.Destroyed=0
        self.ParametersChange = None
        qt.QMainWindow.__init__(self,parent,"Colormap Editor",0)
        #self.table=Parameters(self,labels=['Parameter','Estimation','Fit Value','Sigma',
        #                    'Restrains','Min/Parame','Max/Factor/Delta/'])#,
        #               #paramlist=['Height','Position','FWHM'])
        self.table=Parameters(self)
           
        #self.bEstimate=qt.QPushButton(self)
        #self.bEstimate.setText("Estimate")        
        #self.connect(self.bEstimate,qt.SIGNAL("clicked()"),self.onEstimate)
        #self.bStartFit=qt.QPushButton(self)
        #self.bStartFit.setText("Start Fit")        
        #self.connect(self.bStartFit,qt.SIGNAL("clicked()"),self.onStartFit)
        
                
        self.menuFile = qt.QPopupMenu(self)
        self.menuAction = qt.QPopupMenu(self)
        self.menuConfig = qt.QPopupMenu(self)        
        self.menuBar().insertItem('&File',self.menuFile)
        self.menuBar().insertItem('&Action',self.menuAction)
        self.menuBar().insertItem('&Config',self.menuConfig)
        self.menuFile.insertItem('&New',self.onNewDoc)
        
        self.setCentralWidget (self.table)        
        self.statusBar().message('Ready')
        self.setCaption('Fit Parameters Editor')
        self.resize(600,400)

        self.Weight=self.Theory=self.Background=None
        self.Mode="Normal"
        self.TableParameters=[]


    def onInitialize(self,eh=None,fit=None):
        self.menuConfig.clear()
        self.menuAction.clear()
        self.theory_menu_dict={}
        self.back_menu_dict={}
        self.weight_menu_dict={}
        self.mode_menu_dict={}
        self.Weight=self.Theory=self.Background=None

        if self.eh is not None:
            self.eh.unregister("FitFinished", self.onFitFinished)
        self.eh = eh
        self.fit = fit
        if self.eh is not None:
            self.ParametersChange = self.eh.create("ParametersChange")
            self.eh.register("FitFinished", self.onFitFinished)
        if fit is not None:
            self.menuAction.insertItem('&Estimate',self.onEstimate,qt.Qt.CTRL + qt.Qt.Key_E)
            self.menuAction.insertItem('&StartFit',self.onStartFit,qt.Qt.CTRL + qt.Qt.Key_S)

            self.menuConfigTheory = Menu(self)
            self.menuConfig.insertItem('&Theory',self.menuConfigTheory)
            self.menuConfigBackground = Menu(self)
            self.menuConfig.insertItem('&Background',self.menuConfigBackground)
            self.menuConfigWeight = Menu(self)
            self.menuConfig.insertItem('&Weight',self.menuConfigWeight)
            self.menuConfigMode = Menu(self)
            self.menuConfig.insertItem('&Mode',self.menuConfigMode)
            
            for theory in fit.theorylist:
                self.theory_menu_dict[theory]=self.menuConfigTheory.AddCommand(theory,Command.Command(self.onTheorySelect,theory))
            for background in fit.bkglist:
                self.back_menu_dict[background]=self.menuConfigBackground.AddCommand(background,Command.Command(self.onBackgroundSelect,background))
            for weight in ["Statistical","No weight"]:                
                self.weight_menu_dict[weight]=self.menuConfigWeight.AddCommand(weight,Command.Command(self.onWeightSelect,weight))
            for mode in ["Normal","MCA"]:                
                self.mode_menu_dict[mode]=self.menuConfigMode.AddCommand(mode,Command.Command(self.onModeSelect,mode))
            if fit.fitconfig['weight']:self.onWeightSelect("Statistical")
            else:self.onWeightSelect("No weight")
            self.onTheorySelect(fit.fitconfig['fittheory'])
            self.onBackgroundSelect(fit.fitconfig['fitbkg'])
            self.onModeSelect(self.Mode)


    def onWeightSelect(self,value):
        for weight in self.weight_menu_dict.keys():
            if value==weight:
                self.menuConfigWeight.CheckItem(self.weight_menu_dict[weight],1)
            else:
                self.menuConfigWeight.CheckItem(self.weight_menu_dict[weight],0)
        self.Weight=value
        

    def onTheorySelect(self,value):
        for theory in self.theory_menu_dict.keys():
            if value==theory:
                self.menuConfigTheory.CheckItem(self.theory_menu_dict[theory],1)
            else:
                self.menuConfigTheory.CheckItem(self.theory_menu_dict[theory],0)
        self.Theory=value
                        
    def onBackgroundSelect(self,value):
        for back in self.back_menu_dict.keys():
            if value==back:
                self.menuConfigBackground.CheckItem(self.back_menu_dict[back],1)
            else:
                self.menuConfigBackground.CheckItem(self.back_menu_dict[back],0)
        self.Background=value

    def onModeSelect(self,value):
        for mode in self.mode_menu_dict.keys():
            if value==mode:
                self.menuConfigMode.CheckItem(self.mode_menu_dict[mode],1)
            else:
                self.menuConfigMode.CheckItem(self.mode_menu_dict[mode],0)
        self.Mode=value

        
    def onNewDoc(self):
        self.statusBar().message('New',3000)

    def onEstimate(self):
        self.statusBar().message('Estimate')
        qt.qApp.processEvents()
        #self.fit.estimate()
        self.Apply("ESTIMATE")
        #self.onFitFinished()
        
        #self.Apply()

    def onStartFit(self):
        self.statusBar().message('Start Fit')
        qt.qApp.processEvents()
        self.TableParameters= self.table.fillfitfromtable()
        self.Apply("FIT")
        

    
    def onFitFinished(self,parameters):
        self.statusBar().message('Ready')
        #try:
        if self.Mode=="MCA": self.table.fillfrommca(parameters)
        else:
            self.table.fillfromfit(parameters,current="Region 1")
            for view in self.table.tables.keys():
                if view != "Region 1":
                    self.table.removeview(view)
            
            #if hasattr(self,"oldmode") and self.Mode != self.oldmode:
            #    self.table.fillfromfit(parameters,name="Region 1",delete=1)
            #else:
            #    self.table.fillfromfit(parameters)
            #self.oldmode=self.Mode

        #mcaresult=fit.mcafit(x=x,xmin=x[70],xmax=x[500])
        

        #except:pass
        
    def Show(self):
        self.show()

    def hideEvent(self,e):
        self.Destroyed=1
        qt.QMainWindow.hideEvent(self,e)

    def IsDestroyed(self):
        return self.Destroyed

    """
    def resizeEvent(self,e):
        try:
            width,height=self.width(),self.height()
            start_table=self.menuBar().height()+5            
            button_height=30
            start_button=height-self.statusBar().height()-button_height-5
            end_table=start_button-5
            
            self.table.setGeometry(0,start_table,width,end_table-start_table)
            self.bEstimate.setGeometry(0,start_button,120,button_height)
            self.bStartFit.setGeometry(self.bEstimate.width()+5,start_button,120,button_height)
        except: pass
    """
    
    def Apply(self,action="FIT"):
        """
        Called by ColormapEditorWidget then change takes place
        """
        if self.eh is not None:
            pars={}
            if self.Weight=="Statistical": pars["Weight"]=1
            else: pars["Weight"]=0
            pars["Theory"]=self.Theory
            pars["Background"]=self.Background
            pars["Mode"]=self.Mode
            pars["Action"]=action
            pars["FitPars"]=self.TableParameters
            self.eh.event(self.ParametersChange,pars)


if __name__ == "__main__":
    import sys    
    app = qt.QApplication(sys.argv)
    mw = FitParametersDialog(None,None)
    app.setMainWidget (mw)
    mw.show()
    app.exec_loop()

