import sys
from qt import *
import qttable
import string

DEBUG=0

class McaTable(qttable.QTable):
    def __init__(self, *args,**kw):
        apply(qttable.QTable.__init__, (self, ) + args)
        self.setNumRows(1)
        self.setNumCols(1)
        self.labels=['Parameter','Estimation','Fit Value','Sigma',
                     'Restrains','Min/Parame','Max/Factor/Delta/']
        self.code_options=["FREE","POSITIVE","QUOTED",
                 "FIXED","FACTOR","DELTA","SUM","IGNORE","ADD","SHOW"]

        i=0
        if kw.has_key('labels'):
            self.labels=[]
            for label in kw['labels']:
                self.labels.append(label)
        else:
            self.labels=['Position','Area','Sigma','Fwhm','Chisq',
                         'Region','XBegin','XEnd']
        self.setNumCols(len(self.labels))
        
        for label in self.labels:
            QHeader.setLabel(self.horizontalHeader(),i,label)
            i=i+1
                
        self.regionlist=[]
        self.regiondict={}
        
    def fillfrommca(self,mcaresult):
        line0=0
        region=0
        for result in mcaresult:
            region=region+1
            if result['chisq'] is not None:
                chisq=QString("%6.2f" % (result['chisq']))
            else:
                chisq=QString("Fit Error")
            if 1:
                xbegin=QString("%6g" % (result['xbegin']))
                xend=QString("%6g" % (result['xend']))
                for (pos,area,sigma,fwhm) in result['mca_areas']:
                    line0=line0+1
                    nlines=self.numRows()
                    if (line0 > nlines):
                        self.setNumRows(line0)
                    line=line0-1
                    #pos=QString(str(pos))
                    #area=QString(str(area))
                    #sigma=QString(str(sigma))
                    #fwhm=QString(str(fwhm))
                    tregion=QString(str(region))
                    pos=QString("%6g" % (pos))
                    area=QString("%6g" % (area))
                    sigma=QString("%6.3g" % (sigma))
                    fwhm=QString("%6g" % (fwhm))
                    tregion=QString("%6g" % (region))
                    fields=[pos,area,sigma,fwhm,chisq,tregion,xbegin,xend]
                    col=0
                    for field in fields:
                        key=qttable.QTableItem(self,0,field)
                        self.setItem(line,col,key)
                        col=col+1
