import PSDraw
import EpsImagePlugin
import os
class MyPSDraw(PSDraw.PSDraw):

	def __init__(self,fp=None):
		"""
		constructor : extends PIL PSDraw class
		"""
		PSDraw.PSDraw.__init__(self,fp)
		
	def rectangle(self, box):
		self.fp.write("%d %d M %d %d 0 Vr\n" % box)
	
	def image(self, box, im, cnf={'fit':0,'keepAspect':1}, dpi = None):
		"""
		Write an PIL image in the given box. If the image is bigger than the box, it will be resized to fit it.
		The method returns the final image box (in ps unit) 
		param :
			-	box : the box where the image must be placed in : tuple (xmin,ymin,xmax,ymax) in ps unit
			-	im : the PIL image to be added
			-	cnf : fit image to box configuration dictionnary :
						'fit' : if 1 the image size will be fitted to the box. Default is 0
						'keepAspect' : if 1 the aspect ratio between x and y image size will be maintained.  Default is 1
			-	dpi : default resolution to be used for the image. It is advised to leave it to its default (None). This resolution will be set regarding the image mode 
		"""
		# default resolution depends on mode
		if not dpi:
			if im.mode == "1":
				dpi = 200 # fax
			else:
				dpi = 100 # greyscale

		# max allowed size
		xmax = box[2] - box[0]
		ymax = box[3] - box[1]

		### set resizing coefficients to fit the image to the box ###
		# image size (on paper)
		x = float(im.size[0] * 72) / dpi
		y = float(im.size[1] * 72) / dpi
		# resizing coeff
		sx,sy=1.,1.
		if (x>xmax or y>ymax) or cnf['fit']==1:
			sx=xmax/float(im.size[0])
			sy=ymax/float(im.size[1])
			if cnf['keepAspect']==1:
				s=min(sx,sy)
				sx=sy=s

		### center the image in the box ###
		dx = (box[0]+(float(xmax)-float(im.size[0])*sx)/2.)
		dy = (box[1]+(float(ymax)-float(im.size[1])*sy)/2.)
		self.fp.write("%f %f translate\n" % (int(dx), int(dy)))
		
		### rescale the image if needed ###
		if sx!=1. or sy!=1.: self.fp.write("%f %f scale\n" % (sx, sy))
		
		EpsImagePlugin._save(im, self.fp, None, 0)
		self.fp.write("\ngrestore\n")

		return (dx,dy,dx+float(im.size[0])*sx,dy+float(im.size[1])*sy)
