from Tkinter import *
from dialogbox import *
from prnconf import *
import tkSimpleDialog
import PsCanvas
#import AppPreview
from string import atof

class AppPrint(MyDialog):
    def __init__(self,master,text='',dict=None,prnconf=None,**args):
        if not prnconf:
            if not master.printconfig:
                master.printconfig = PrintConfig()
            prnconf = master.printconfig
        if not prnconf.childstc.has_key('App'):
            prnconf.childstc['App'] = ['', '', None, None, 1.0]
        
        blst = prnconf.childstc['App']
        blst[0] = text
        blst[1] = ''

        self.master=master            
        new = old = None
        if dict and len(dict.keys()):
            new = dict.keys()
            new.sort()            
            if blst[2] and len(blst[2].keys()):
                old = blst[2].keys()
                old.sort()
                
            if new != old:
                blst[2] = {}
                for key in new:
                    if len(dict.keys()) == 1:
                        blst[2][key] = 1
                    else:
                        blst[2][key] = 0

            blst[3] = dict
        else:
            blst[2] = blst[3] = None

        args = args.copy()
        args['dlgclass'] = AppPrnDlg
        apply(prnconf.do_print_task, (master.winfo_toplevel(), self.printps), args)

    def printps(self,prnconf,fname,**kw):
        blst = prnconf.childstc['App']
        dict = blst[3]
        blst[3] = None
        if dict:
            keys = dict.keys()
            keys.sort()
            psfiles = {}           
            for key in keys:
                if blst[2][key]:
                    tupla=dict[key]
                    psfiles[key] = str(fname + '.' + key)
                    apply(tupla[1],(tupla[0],psfiles[key]))
        pgsize = prnconf.pgsize
        pgbd = prnconf.pgborders
        width = "%fm" % (pgsize[0] - (pgbd[2] + pgbd[3]))
        height = "%fm" % (pgsize[1] - (pgbd[0] + pgbd[1]))
        cvs = PsCanvas.PsCanvas(self.master,width=width,height=height)

        cvs.width = atof(cvs.cget('width'))
        cvs.height= atof(cvs.cget('height'))
        
        previewfiles=[]
        if dict:
            keys = dict.keys()
            keys.sort()
            for key in keys:
                if blst[2][key]:
                    previewfiles.append(psfiles[key]+".epsi")
        x = x2 = 0
        y = y2 = 0
        n_parts = len(previewfiles)
        if n_parts > 1:
            if prnconf.pglandscape:
                n_partsx = 2
                n_partsy = int(n_parts/2) + n_parts % 2
            else:
                n_partsy = 2
                n_partsx = int(n_parts/2) + n_parts % 2
            deltax = cvs.width / n_partsx
            deltay = cvs.height / n_partsy
            index_inc = 1
        else:
            n_parts = 1
            deltax = deltay = 0
            n_partsx = n_partsy = 0
            index_inc = 0
        n = x0 = y0 = i = j = 0
        if dict:
            keys = dict.keys()
            keys.sort()
            for key in keys:
                if blst[2][key]:
                    #Use ps2epsi in order to get the proper bounding box
                    #that allows to visualize the image too!
                    #Just avoid the script
                    #cmd = "/bliss/users/sole/Python/SPECPLOT/pysrc/"                   
                    #cmd = ""                    
                    #cmd = "%sAppPrintScript %s %s.epsi" % (cmd,psfiles[key],psfiles[key])
                    #os.system(cmd)
                    cmd = "rm -f %s.epsi\n" % psfiles[key]
                    os.system(cmd)
                    cmd = "ps2epsi %s %s.tmp\n" % (psfiles[key],psfiles[key])
                    noghostscript=os.system(cmd)
                    if noghostscript:
                        print "*********************************************"
                        print "* Please make sure ghostscript is installed *"
                        print "*        because ps2epsi is needed          *"
                        print "*********************************************"                    
                        cmd="cp -f %s %s.epsi\n" % (psfiles[key],psfiles[key])
                        os.system(cmd)
                    else:  
                        cmd = "sed \"s/%%%%BeginPreview/%%%%EndComments\\\\\n"
                        cmd = "%s%%%%BeginPreview/\" %s.tmp > %s.epsi" % (cmd,psfiles[key],psfiles[key])
                        #cmd = "%s%%%%BeginPreview/\" %s.tmp > test.epsi" % (cmd,psfiles[key])
                        cmd = "%s\nrm -f %s.tmp" % (cmd,psfiles[key])
                        os.system(cmd)
                    x = x0 + i * deltax
                    y = y0 + j * deltay
                    eps = cvs.create_eps(x,y,anchor=NW,
                            #width=deltax,height=deltay,
                            file=psfiles[key]+".epsi")
                    i += 1
                    if i >= n_partsx:
                        i = 0
                        j += 1
                        if j >= n_partsy:
                            j = 0
                    bbox = cvs.bbox(eps)
                    if (bbox [2] - bbox [0]) >= deltax:
                        setwidth = deltax
                    else:
                        setwidth = 0
                    if (bbox [3] - bbox [1]) >= deltay:
                        setheight = deltay
                    else:
                        setheight = 0
                    cvs.delete(eps)
                    eps = cvs.create_eps(x,y,anchor=NW,
                            width=setwidth,height=setheight,
                            file=psfiles[key]+".epsi")                        
                    #cvs.create_rectangle(x, y, bbox[2], bbox[3])
                    cvs.create_rectangle(x, y, x + deltax, y + deltay)
                    os.remove(psfiles[key])
                    os.remove(psfiles[key]+".epsi")
                    #previewfiles.append(psfiles[key]+".epsi")
        #print previewfiles

        cvs.create_text(bbox[2]/2,0,anchor=N,text=blst[0])
        y = bbox[3] + 5
        if len(blst[1]):
            text = 'Comment: ' + blst[1]
            cvs.create_text(0,y,anchor=NW,text=text)

        pwidth = "%fm" % pgsize[0]
        pheight = "%fm" % pgsize[1]
        x = "%fm" % pgbd[2]
        if prnconf.pglandscape:
            y = "%fm" % pgbd[1]  # landscape: lower border (inverted)
        else:
            y = "%fm" % (pgsize[1] - pgbd[0]) # portrait: y increase upwards

        fwidth = "%fm" % (pgsize[0] * blst[4])
        cvs.postscript(width=pwidth,height=pheight,pagex=x,pagey=y,pageanchor=NW,
                       pagewidth=fwidth, rotate=prnconf.pglandscape,file=fname,
                       colormode=prnconf.colormode)
        #drawing=AppPreview.AppPreview()
        #drawing.width=pgsize[0]
        #drawing.height=pgsize[1]
        #drawing.root=Toplevel()
        #drawing.createInterface(files=previewfiles)

class AppPrnDlg(PrintDlg):

    def __init__(self, master, prnconf, **args):
        blst = prnconf.childstc['App']        
        self.blst = blst

        self.gtitle = StringVar()
        self.gtitle.set(blst[0])
        self.comment = StringVar()
        self.comment.set(blst[1])

        self.varlablist = {}
        if blst[2] and len(blst[2].keys()):
            for key in blst[2].keys():
                var = IntVar()
                var.set(blst[2][key])
                self.varlablist[key] = var

        args = args.copy()
        args['psdlgclass'] = AppPageSetupDlg
        apply(PrintDlg.__init__, (self, master, prnconf), args)

    def usrbody(self, usrdict):
        fm = self.get_frame()

        lb = Label(fm, text = 'Title:')
        lb.grid(row = 0, col = 0, sticky = W)

        entry = Entry(fm, width = 25, textvariable = self.gtitle)
        entry.grid(row = 0, col = 1, sticky = W)

        row = 1
        if len(self.varlablist.keys()):
            keys = self.varlablist.keys()
            keys.sort()
            for key in keys:
                var = self.varlablist[key]
                cb = Checkbutton(fm, text = key, variable = var)
                cb.grid(row = row, col = 0, columnspan = 2, sticky = W)
                row = row + 1

        lb = Label(fm, text = 'Comment:')
        lb.grid(row = row, col = 0, sticky = W)

        entry = Entry(fm, width = 25, textvariable = self.comment)
        entry.grid(row = row, col = 1, sticky = W)

    def usrapply(self, usrdict):
        blst = self.blst
        blst[0] = self.gtitle.get()
        blst[1] = self.comment.get()

        for key in blst[2].keys():
            blst[2][key] = self.varlablist[key].get()

class AppPageSetupDlg(PageSetupDlg):

    def __init__(self, prndlg, **args):
        blst = prndlg.prnconf.childstc['App']
        self.blst = blst

        self.amp = NumEntry(double = 1, format = '%.3f', 
                           val = blst[4], range = (0.01, 100))

        apply(PageSetupDlg.__init__, (self, prndlg), args)


    def usrbody(self, usrdict):
        fm = self.get_frame()
        lb = Label(fm, text = 'Amplification factor:')
        lb.grid(row = 0,column = 0)

        self.amp.create_entry(fm, width = 5)
        self.amp.entry.grid(row = 0, column = 1)

    def usrapply(self, usrdict):
        blst = self.blst
        blst[4] = self.amp.get()


class AppPrintMain(Frame):
    def __init__(self,master):
        import SpecGraph
        import Numeric
        import EventHandler
        root = master
        eh = EventHandler.EventHandler()
        app = SpecGraph.SpecGraph(root,eventhandler=eh)
        xs    = ['Equis', Numeric.array([1,2,3,4,5,6,7])]
        data  = ['Counts','Equis',Numeric.array([1,2,3,4,3,2,1])]
        data2 = ['Square','Equis',Numeric.array([1,4,9,16,9,4,1])]

        #old fashion, without Events:
        #app.setx(xs)
        #app.sety(data)
        #app.sety(data2)
        
        #New fashion data as events
        XNewDataEvent=eh.create('XNewDataEvent')
        eh.event(XNewDataEvent,data={'xname' : 'Equis',
                                 'xdata':xs[1]})
        YNewDataEvent=eh.create('YNewDataEvent')
        eh.event(YNewDataEvent,data={'xname' : 'Equis',
                    'yname' : 'Counts','ydata':data[2]})
        eh.event(YNewDataEvent,data={'yname':data2[0],'xname':data2[1],
                    'ydata':data2[2],'color':'red'})    
        root.geometry("500x400+50+50")
        root.title("Blissgraph")
        app.pack(fill='both',expand='yes')
        dict={}
        dict['Graph'] = (app,SpecGraph.SpecGraph.printps)
        #dict['Specfit'] = (self,AppPrintMain.specfitprintps)
        #dict['Key 3'] = 'This is text for Key 3'
        root = master
        self.prnconf = PrintConfig()
        self.prnconf.childstc ['App'] = ['', '', None, None, 1.0]
        pbut = Button(root,text='Print',command = lambda a=self,b=root,c=dict:a.myprinttest(b,c))
        pbut.pack()
        #app.pack(fill=BOTH,expand=YES)
        root.mainloop()

    def specfitprintps(self,fname):
        print "I should generate a postscript file ",fname," here"
         
    def graphprintps(self,fname):
        print "I should generate a postscript file ",fname," here"
    
    def myprinttest(self,master,dict):
        AppPrint(master,text='Application graph printing',dict=dict,prnconf=self.prnconf)

if __name__ == '__main__':
    root=Tk()
    a=AppPrintMain(root)
    root.mainloop()
