#!/usr/bin/env python
from Tkinter import *
from Tkinter import _cnfmerge

class ScrollFrame(Frame):

     def __init__(self,master,cnf={},**kw):
          cnf = _cnfmerge((cnf,kw))

          self.cont = Frame(master,cnf)
          self.cnv  = Canvas(self.cont,cnf)
          self.ysb  = Scrollbar(self.cont,command=self.cnv.yview)
          self.xsb  = Scrollbar(self.cont,command=self.cnv.xview,
                                orient='horizontal')
          self.cnv['yscrollcommand'] = self.ysb.set 
          self.cnv['xscrollcommand'] = self.xsb.set 

          Frame.__init__(self,self.cnv,cnf)

          self.cnv.grid(row=0,column=0,sticky='nsew')

          self.cont.rowconfigure(0,weight=1)
          self.cont.columnconfigure(0,weight=1)

          self.cnv.create_window(0,0,anchor='nw',window=self)

          self.cnv.bind('<Configure>',self.resize)
          self.bind('<Configure>',self.resize)

     def pack(self,**kw):
          self.cont.pack(kw)
     def grid(self,**kw):
          self.cont.grid(kw)
     def pack_forget(self,**kw):
          self.forget(kw)
     def grid_forget(self,**kw):
          self.grid_forget(kw)

     def resize(self,event):
          bb = self.cnv.bbox(ALL)
          wid = self.cnv.winfo_width()
          hgt = self.cnv.winfo_height()
          if bb[3] > hgt:
             self.ysb.grid(row=0,column=1,sticky='ns')
          else:
             self.ysb.grid_forget()
          if bb[2] > wid:
             self.xsb.grid(row=1,column=0,sticky='ew')
          else:
             self.xsb.grid_forget()
          self.cnv.configure(scrollregion=self.cnv.bbox(ALL))


def testone():
    """
    Scrollform test function.
    """
    def fillit(pere):
         for i in range(10):
            tt = "Label the label this lable is %d" % i
            txt = Label(pere,text=tt)
            txt.pack(side='top',expand='yes')

    root = Tk()
    bla = ScrollFrame(root,width=50,height=50)
    fillit(bla)
    bla.pack(fill='both',expand='yes')
    root.mainloop()


if __name__ == '__main__':
     testone() 
   
