#!/usr/bin/env python

import sys, Numeric

# Import the CORBA module
from omniORB import CORBA
import CosNaming

# Import the stubs for the global module
from odak.phoenix.phoenix_corba import *
import phoenix, string

# Initialise the ORB
#orb = CORBA.ORB_init(sys.argv, CORBA.ORB_ID)
orb = CORBA.ORB_init(["python", "-ORBInitialHost", "astros.esrf.fr", "-ORBInitialPort", "19000"], CORBA.ORB_ID)

# Get the IOR of an Echo object from the command line (without
# checking that the arguments are sensible!)
#ior = sys.argv[1]
#ior = open("omni-python.ior").readline()

# Convert the IOR to an object reference
#obj = orb.string_to_object(ior)

obj = orb.resolve_initial_references("NameService")
rootContext = obj._narrow(CosNaming.NamingContext)

if rootContext is None:
  print "Failed to narrow the root naming context"
  sys.exit(1)

name = [CosNaming.NameComponent("phoenix", ""),
        CosNaming.NameComponent("ImageServer", "")]

try:
  obj = rootContext.resolve(name)

except:
  print "'Test Server 1' not found"
  sys.exit(1)
 


# Narrow reference to an Echo object
ts  = obj._narrow(phoenix.corba.stub.CorbaOperation)

if ts is None:
    print "Object reference is not a CorbaOperation"
    sys.exit(1)

# Invoke the echoString operation
ds1 = ts.getNodes()[0]

MAX_ELEMENTS = 100000
dataCount = ds1.getDataCount()
no_parts = dataCount/MAX_ELEMENTS
for i in range(no_parts):
  any = ds1.getData(i)
  data = any.value()
  print len(data)









