/*+++***********************************************************************
NAME

    refract.h

SYNOPSIS

    #include "refract.h"

DESCRIPTION
    Header of the module "refract.c"
***********************************************************************---*/
#ifndef _REFRACT_
# define _REFRACT_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

typedef struct refract_dir {
  int    status;
  double sinTwoTheta;
  double cosTwoTheta;
  double sinAlpha;
  double cosAlpha;
  } RefractDir;

/*===========================================================================*/

/***************************************************************************
* Functions                                                                *
***************************************************************************/
PUBLIC extern int 
       refract_Init ( FILE * out, double Delta, double Psi, double Chi );

PUBLIC extern RefractDir 
       refract_Angles ( RefractDir Beamp );

PUBLIC extern void
       refract_PrintBeam ( FILE * out, RefractDir Beamp ),
       refract_PrintParams ( FILE * out );

#endif
