/******************************************************************************/
/* edftiff.h                                                                  */
/******************************************************************************/

#ifndef _EDF_TIFF

// TIFF output routine (bps: 8|16|32, compression: no=1, dpcm: points per cm)
extern void
 * float2unsigned (float * src, float dummy, float ddummy,
                   long xdim, long ydim, int autorange, 
                   int automin, float vmin, int automax, float vmax,
                   short bps, char comment[], int * pstatus);

extern int
   write_tiff ( const char * fname, long xdim, long ydim, short bps,
                short compression, const void * data, int orientation,
                const char * description, float xdpcm, float ydpcm,
                int * pstatus );

// TIFF error status
# include "SaxsError.h"

# define TIFF_STATUS_ERROR         Failed 
# define TIFF_STATUS_SUCCESS       Success
# define TIFF_STATUS_OPENERROR     FileOpeningError
# define TIFF_STATUS_READERROR     FileReadError
# define TIFF_STATUS_WRITEERROR    FileWriteError
# define TIFF_STATUS_SIZEMISMATCH  SizeMismatch

# define _EDF_TIFF
#endif

