/* @(#) $Source: GetCCDFrame.h V2.5 by P. Daly, P. Boesecke Jul 1997    $ */
/**************************************************************************/
/* GetCCDFrame.h                                                          */
/**************************************************************************/

#ifndef _GETDLDFRAME_ROUTINES 
#define _GETDLDFRAME_ROUTINES

#define HScalerLen 32 
#define HScalerNameLen 10

#ifdef __STD__
  extern int 
     ReadCCDData (FILE *stream, int FrameNumber, void **Start),
     ReadCCDDataV1 (FILE *stream, int FrameNumber, void **Start),
     GetMaxCCDNumber (FILE *stream, int *Maximum),
     ReadCCDType (FILE *stream, int *X, int *Y, int *DataLength,
                   int * OffsetX, int * OffsetY),
     ReadCCDScalars (FILE *stream, char **HmDldVersion, 
         float Scalars[HScalerLen],
         char *ScalarName[HScalerLen],
         float ScalarZero[HScalerLen],
         float Scalaralib[HScalerLen],
         float *ScalarDepth,
         int *ScalarI0, int *ScalarI1,
         int *ScalarAnode, int *ScalarTime,
         int *ScalarI0S, int *ScalarI1S,
         int *ScalarAnodeS, int *ScalarTimeS,
         float *HmDeltaTime, 
         char HmStartTime[],
         int FrameNumber),
     ReadCCDInfo(FILE * stream, 
         char * DetectorType[], 
         char * MachineInfo[],
         char * OpticsInfo[],
         char * StationInfo[],
         char * ProposalInfo[]),
     ReadCCDExperiment(FILE * stream,
         char * Title[], char * ExperimentInfo[],
         float * enter_1, float * Center_2, int * ICenter,
         float * PixSize_1, float * PixSize_2, int * IPixSize,
         float * WaveLength, int * IWaveLength,
         float * SampleDistance, int * ISampleDistance,
	 float * DetectorPosition, int * IDetectorPosition,
         float * DataValueOffset, IDataValueOffset,
         float * Dummy, int * IDummy);
#else
   extern int
     ReadCCDData(),
     ReadCCDDataV1(),
     GetMaxCCDNumber(),
     ReadCCDType(),
     ReadCCDScalars(),
     ReadCCDInfo(),
     ReadCCDExperiment(); 
#endif

#endif /* _GETDLDFRAME_ROUTINES */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

