import Command, sys, qt,types
sys.path.insert(0,'.')
sys.path.insert(0,'./maths')

from PyDisWindow import Plugin,ViewWindow
import PyDVT.DataSelection as DataSelection
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
from PyDVT.Binding import Pen,Brush
from ConstantParameterDialog import ConstantParameterDialog
from ErrorWindow import ErrorWindow
from Py4datDisplay import ViewSelectHRect,Py4datImageViewRoi

##### Transformation Filters #####
from AddConstantFilter import AddConstantFilter
from MultiplyByConstantFilter import MultiplyByConstantFilter
from SubstractBackgroundFilter import SubstractBackgroundFilter
from LeftRightFlipFilter import LeftRightFlipFilter
from TopBottomFlipFilter import TopBottomFlipFilter
from TransposeFilter import TransposeFilter


__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '13/12/2002'

DEBUG=0

class Py4datMathsPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		return 1

     	def OnInitMenuBar (self,menu_bar):
        	if DEBUG: print 'In Py4datMathsPlugin.OnInitMenuBar...'
		menuFile=menu_bar.children()[0]
        	menuFile.insertItem('Open Background',self.OpenBackground,0,-1,5)
		self.menu_plugin = qt.QPopupMenu(menu_bar)
		self.menu_plugin.insertItem('Flip Left/Right',self.LeftRightFlip)
		self.menu_plugin.insertItem('Flip Top/Bottom',self.TopBottomFlip)
		self.menu_plugin.insertItem('Transpose',self.Transpose)
		self.menu_plugin.insertSeparator()
        	self.menu_plugin.insertItem('Add Constant',self.AddConstant)
		self.menu_plugin.insertItem('Multiply by Constant',self.MultiplyByConstant)
		self.menu_plugin.insertSeparator()
		self.menu_plugin.insertItem('Substract Constant * Background',self.SubstractBackground)
		menu_bar.insertItem('&Transformation',self.menu_plugin)
		
    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datMathsPlugin.OnFinishInit...'
		self.app_window=app_window
		self.app_window.Constant=1

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datMathsPlugin.OnInitWindowPopupMenu...'
		window.Transformation=[]

	def GetInfoString(self):
		return "v. "+__version__

    	########################################################
    	### Private methods
    	########################################################	

	def OpenBackground(self):
		if DEBUG: print 'In Py4datBackgroundPlugin.OpenBackground...'
        	self.app_window.onOpen()
		activeWindow=self.app_window.mdi.activeWindow()
		if activeWindow==None:return
		activeWindow.setCaption('Background Image -' + activeWindow.name)
		if activeWindow==None: return
		self.app_window.BackgroundOutput=activeWindow.View.GetSource()[0].GetOutput()

	def ConstantChoice(self):
		self.dial=ConstantParameterDialog(None,{'Constant':self.app_window.Constant})	
		self.app_window.Constant=self.dial.Constant
		
	def Transform(self,param):
		if DEBUG: print 'In Py4datMathsPlugin.Transform...'
		if param=='BKG' and hasattr(self.app_window,'BackgroundOutput')==0: 
			dial=ErrorWindow(None,message=' You must open 1 background image !',sizex=237,sizey=60)
			return
		window=self.app_window.mdi.activeWindow()
		if param=='BKG' and self.app_window.BackgroundOutput['data'].shape != window.View.Source[0].GetOutput()['data'].shape:
			dial=ErrorWindow(None,message=' The 2 images must have the same shape !',sizex=237,sizey=60)
			return
		if window is None: return
		
		if param=='BKG' or param=='ADD' or param=='MULTIPLY':
			self.ConstantChoice()
			if self.dial.dlg.result()==0: return
		
		transformedWindow=self.app_window.GetWindow('Transformed - '+ window.name)
		if transformedWindow is None:
			transformedWindow=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,name='Transformed - '+ window.name,view_pars={"UseImageValues":1},master_window=window)
			transformedWindow.SetTitle(transformedWindow.name)
			self.app_window.Set2DViewMenu(transformedWindow)
			transformedWindow.DataSelection=window.View.Source[0]
			window.Transformation=[]
		else : transformedWindow.DataSelection=transformedWindow.View.Source[0]
		
		if param=='ADD': transformedWindow.Filter=ImageView.ColormapFilter(None,AddConstantFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant))
    		elif param=='MULTIPLY': transformedWindow.Filter=ImageView.ColormapFilter(None,MultiplyByConstantFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant))
		elif param=='BKG': transformedWindow.Filter=ImageView.ColormapFilter(None,SubstractBackgroundFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant,BackgroundOutput=self.app_window.BackgroundOutput))
		elif param=='LRFLIP': transformedWindow.Filter=ImageView.ColormapFilter(None,LeftRightFlipFilter(transformedWindow.DataSelection,buffer_input=1))
		elif param=='TBFLIP': transformedWindow.Filter=ImageView.ColormapFilter(None,TopBottomFlipFilter(transformedWindow.DataSelection,buffer_input=1))
		elif param=='TRANS': transformedWindow.Filter=ImageView.ColormapFilter(None,TransposeFilter(transformedWindow.DataSelection,buffer_input=1))
		transformedWindow.Filter.SetColormapParameters(window.Filter.GetColormapParameters())
		transformedWindow.View.SetSource(transformedWindow.Filter)
		
		if param=='ADD' or param=='MULTIPLY': Transformation=[param,self.app_window.Constant]
		elif param=='BKG': Transformation=[param,self.app_window.Constant,self.app_window.BackgroundOutput]
		elif param=='LRFLIP' or param=='TBFLIP': Transformation=[param]
		window.Transformation.append(Transformation)
		
	def AddConstant(self):
		param='ADD'
		self.Transform(param)
		
	def MultiplyByConstant(self):
		param='MULTIPLY'
		self.Transform(param)
		
	def SubstractBackground(self):
		param='BKG'
		self.Transform(param)	
		
	def LeftRightFlip(self):
		param='LRFLIP'
		self.Transform(param)
		
	def TopBottomFlip(self):
		param='TBFLIP'
		self.Transform(param)
	
	def Transpose(self):
		param='TRANS'
		self.Transform(param)


plugin=Py4datMathsPlugin()
