"""
    Py4datPyMLabPlugin.py
"""
import qt, Command, string,os,time
from PyDVT.Binding import *
from PyDisWindow import Plugin
import ReadEdfFile
# import AzimInt
print "----------------------------------------------------------------------------------------------------"

from PyDisWindow import *
import PyDVT.DataSelection as DataSelection
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.ImageView as ImageView
import PyDVT.GraphView as GraphView
from PyDVT.View import    View

__version__=  '1.0.0'
__author__ =  'Alessandro Mirone (mirone@esrf.fr)'


DEBUG=1
_DataSelection=DataSelection



def add_quotes(s):
    pos=string.find(s,"=")
    if(pos==-1): return s
    pos=pos+1
    new_s=s[:pos+1]
    toggle=0
    while(pos<len(s) and s[pos]==" "):
        pos=pos+1
    if(pos==len(s)):
        return s
    new_s=new_s+"\""
    while(pos<len(s) and s[pos]!=" "):
        new_s=new_s+s[pos]
        pos=pos+1
    new_s=new_s+"\""
    return new_s
    
def treat_par_file(s):

    s=string.replace(s,"!","#")
    lines=string.split(s,"\n")
    new_lines=""
    for line in lines:
        if( string.find(line,"BYTEORDER")>=0 ):
            line=add_quotes(line)
        new_lines=new_lines+"\n"+line
    return new_lines




class  MLab:
	""" this is the interface with Py4DAT/PyDIS widgets
	and data formats.
	To get Help call the Help() metyhod
	"""
	additionalHelps={
	"HOWTOPLOT_1d": " Look newWindow_1d or the shortcut provided by Plot_1d",
	"HOWTOPLOT_2d": " Look newWindow ",
	}
	def PrintMenu(self):
		print " HELP IS AVAILABLE ON THE FOLLOWIN METHOD ( MLab.Help(\"method\" ) )\n "
		for tok in dir(self) :
                        if( tok in [ "PrintHelp",    "PrintMenu",   "__init__",    "appw" ]):
                           continue
			meth=getattr(self, tok)
			if(hasattr(meth, "__doc__")  ):
				print tok , " ",
		print "\n "
		print " HELP IS AVAILABLE ALSO ON THE FOLLOWING SUBJETS ( MLab.Help(\"subjet\" ) ) \n "
		for tok in self.additionalHelps.keys():
			print tok , " ",
                print ""

	def PrintHelp(self, subj):
                tok = getattr(self,subj)
		print 		getattr( tok , "__doc__")
		if( hasattr(tok, "__init__")):
			print " The following help is extracted from __init__ method "
			print 		getattr( getattr(tok,"__init__")  , "__doc__")

	def Help(self,subj=""):
		if (subj ==""):
			self.PrintMenu()
 		else:
			if( (subj in dir(self) and hasattr( getattr(self,subj), "__doc__"))   ):
				self.PrintHelp(subj)
			elif( subj in self.additionalHelps.keys() ):
				print self.additionalHelps[subj]+"\n"
			else:
				print " No help available. Help is available for "
				self.PrintMenu()

        def __init__(self):
	      import AsciiMatrix
              self.AsciiReader = AsciiMatrix.AsciiMatrixReader
              self.AsciiWriter = AsciiMatrix.AsciiMatrixWriter
	      import MLabData
	      self.MLabData=MLabData.MLabData



	def Data_for_Graph(self, *args, **argc):
                """  Data_for_Graph(source)
		     where source is a data derived class.

		     Gives an output that is ready to be plotted by a GraphView
		     widget

		     See Help for function newWindow_1d to 
		     see a practical example on how plotting a graph

		     More advanced use of Data_for_Graph requires that you pass arguments in this format:
                     
			Data_for_Graph(name=None,source=None,synchronized=1,
					buffer_input=0,yscale=0,xdata=None,
					pen=Pen((0,0,0),2,"solid"),symbol="none"
				  )

		     the function Data_for_Graph return  from GraphFilter
		     This help extracted from PyDVT GraphFilter
                     ( print GraphView.GraphFilter.__init__.__doc__ )
                     will be useful for you

		""" 
		import copy
		dictio=copy.copy(argc)
		if(len(args)==1 and len(argc)==0):
	 		graphdata=DataSelection.DataSelection(args[0])
		elif(len(args)>=2):
			graphdata=DataSelection.DataSelection(args[1])
			dictio["name"]=args[0]
		else:
			graphdata=DataSelection.DataSelection(argc["source"])

		dictio["source"]=graphdata

		graphdata=GraphView.GraphFilter(**dictio)
		return graphdata

        Data_for_Graph.__doc__=Data_for_Graph.__doc__+ GraphView.GraphFilter.__init__.__doc__


	def newWindow_1d(self, name=""):
		"""" newWindow_1d(self, name="") :
		returns a window where you can plot 1D graphs.
		The plotting is then done calling 

                    w.SetSource((g1,g2,... ) )

		where w is the newWindow_1d return value (  PyDis's ViewWindow instance)
                where  g1, g2...gn are instance of GraphFilter derived classes.
                MLab provides a shortcut to create Such class with the function
                   MLab.Data_for_Graph.... see corresponding documentation

		EXAMPLES FOR DISPLAYING A GRAPH: 




	















w= MLab.newWindow_1d()

import Numeric

a=Numeric.sin(Numeric.arrayrange(0.0,12,0.1))
c=Numeric.cos(Numeric.arrayrange(0.0,12,0.1))

a_data=MLab.MLabData(a)
c_data=MLab.MLabData(c)

g2= MLab.Data_for_Graph(a_data)
g1= MLab.Data_for_Graph(c_data)

w.View.SetSource((g1,g2))		
			

		For a more advanced use of Data_for_Graph refer to MLab.Help("Data_for_Graph")
	        You'll find there a complete list of options
		"""
		return ViewWindow (MLab.appw.mdi,GraphView.GraphView,
			name,
			{"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
			)


        def ReadTomo(self, name, nslice):
          """ReadTomo(self, name, nslice)
             return slice number nslice slice
             info file must be present
          """
	  import string
	  import sys
	  info= name+".info"
	  sinfo = open(info, "r"  ).read()
	
	  s = treat_par_file(sinfo)
	  exec(s, locals(), locals())
	  print locals()
	  slice_size = NUM_X * NUM_Y * 4
	
	  fimages = open(name,"r")
	
	  if nslice> NUM_Z :
	     raise " nslice too big "
	
	  for i in range(nslice-1) :
	     fimages.seek( slice_size  , 1)
	  s = fimages.read(slice_size )
	
	
	  data= Numeric.fromstring(s,"f")
	
	  if sys.byteorder=="big":
	        byteorder  = "HIGHBYTEFIRST"
	  else:
	        byteorder  =  "LOWBYTEFIRST"
	    
	  if(byteorder != BYTEORDER):
	      data=data.byteswapped()
	  data=Numeric.reshape(data, [NUM_Y  , NUM_X ]  )
	  return data
	

        def ShowTomoSlices(self, name, nslices):
          """ReadTomo(self, name, nslices)
             shows slices specified by nslices
             nslices may be either an integer or a list of integers
          """

          if( type(nslices)==type(1)):
               nslices=[nslices]
          mldata=MLab.MLabData(SourceName=name)
          for i in nslices:
               a= self.ReadTomo(name, i)
               mldata.LoadSource(array=a, append=1)
          w=self.newWindow(mldata)
          return w	
	
	def newWindow(self, data, Name="", DataSelection=None):
		"""
		-- newWindow(data, Name="") create a new window displaying 2D data
	   	The window reference is returned

		EXAMPLE :

import Numeric
a=Numeric.sin( Numeric.arrayrange(0,12.0,0.1 ))
A=a[:,None]*a
mldata=MLab.MLabData(A)
w=MLab.newWindow(mldata)
 


		"""	
		if Name=="":
			Name=data.SourceName
		
                window=ViewWindow (self.appw.mdi,
				   ExtendedImageView.ExtendedImageView,
				   Name,
				   {"AddSelection":0,
				    "SelectionCallback":self.appw.EventSelection,
				    "UseColormapWidget":1,
				    "AddReduc":1}
				   )
                window.shortName=Name
                window.fileName="NONCIVUOLE1"
                window.Data=data

		if(DataSelection is None):
			window.DataSelection=_DataSelection.RectSelection(window.Data)
		else:
	                window.DataSelection=DataSelection
			
                window.Filter=ImageView.ColormapFilter(None,window.DataSelection)

                window.View.SetSource(window.Filter)
                info=window.Data.GetSourceInfo()
                window.NumImages=info["Size"]
                MLab_Set2DArrayViewMenu(self.appw, window)
                self.appw.PageSelect(window,0)

		return window
	




	def Plot_1d( self, *argv):
	  """
	    This function is meant to provide a very easy interface to plotting utilities
            Input is in the form :
                Function_name( (y1,x1   ), (y2,x2), (y3), .....              )

	    Where the y's and the x's are Numpy arrays. 
            The obtained widget plots the y's versus the x's.
            When x is not provided an integer array ranging from
            0 to len(y)-1 is used.

            The return value is a dictionary containing the
            following keywords/ values : ( Example )

       {'graphs': [
                     {'y_data': <MLabData.MLabData instance at 0x8539ce4>, 
                      'y_graph': <PyDVT.GraphView.GraphFilter instance at 0x853adc4>}
                  ],
                'w': <PyDisWindow.ViewWindow instance at 0x851adb4>
       }

           To the keyword "graphs" correspond a list of couple ( MLabData.MLabData , PyDVT.GraphView.GraphFilter).
           One such couple for each (y,x) couple that you provided as argument.

           The 'w' key point to the widget objet. You can add labels and titles by manipulation
           of the object w.View.

	  """
	  res={}
	  w=MLab.newWindow_1d()
	  res["w"]=w
	  graphs=[]
	  toplot=[]
	  for tok in argv:
	     ng={}
	     if len(tok)==1:
	       x=range(len(tok[0]))
	     else:
	       x=tok[1]
	     y = tok[0]
	     y_data = MLab.MLabData( y )
	     y_graph = MLab.Data_for_Graph(source=y_data, xdata=x)
	     ng["y_data"]=y_data
	     ng["y_graph"]=y_graph
	     graphs.append(ng)
	     toplot.append(y_graph)
	  w.View.SetSource(toplot)
	  res["graphs"]=  graphs
	  return res








def MLab_Set2DArrayViewMenu(appw,window):
        window.View.AddMenuSeparator()
        cascademenu=Menu(window.View.GetPopupMenu())
        cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        cascademenu.AddSeparator()
	print " NumImages  ", window.NumImages 
        if window.NumImages > 1:
            cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=appw.EventDepthSelection),"radiobutton")        
            cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=appw.EventDepthSelection),"radiobutton")
            cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=appw.EventDepthSelection),"radiobutton")
            cascademenu.AddSeparator()
        cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        cascademenu.SetCheckedRadio("Clear Selection")
        window.View.AddMenuPopupCascade("Selection",cascademenu)
        appw.Set2DViewMenu(window)
        window.View.AddMenuSeparator()
        if window.NumImages > 1:
            window.image_selection_menu=Menu(window.View.GetPopupMenu())
            for i in range(window.NumImages): window.image_selection_menu.AddCommand(str(i+1),Command.Command(appw.PageSelect,window,i),"radiobutton")
            window.image_selection_menu.SetCheckedRadio("1")
            window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            appw.AddImageSlider(window,appw.onImageSelectionSliderChanged)

	
class cmdln_QTextEdit(qt.QTextEdit):
	def __init__(self,*args,**keys):
		qt.QTextEdit.__init__(self,*args,**keys)
        def keyPressEvent( self,  e ):
		tx=  e.ascii()
		sta = e.state()
		if( sta ==qt.Qt.ShiftButton  and tx==13):
			s=self.selectedText()
			if(str(s)==""):
				(para,inde)=self.getCursorPosition()
				s=self.text(para)
			self.emit(qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),(s,))
		else:
			qt.QTextEdit.keyPressEvent(self,e)
		
class Py4datPyMLabPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'Py4datPyMLabPlugin.OnStartInit'
		self.displayMlab=0
		self.inputFiles=[]
		return 1

    	def OnInitMenuBar (self,menu_bar):
		if DEBUG: print 'In PyMLabPlugin.OnInitMenuBar...'
		self.menu_plugin = qt.QPopupMenu(menu_bar)
		self.menu_plugin.insertItem('&PyMLabPlugin',self.PluginInfo)
		menu_bar.insertItem('Plugins Info',self.menu_plugin)

	def PluginInfo(self):
		if DEBUG: print 'In PyMLabPlugin.PluginInfo...'
		new_window=ViewWindow (self.app_window.mdi,TextView)        
		new_window.show()
		new_window.SetTitle("Plugin Info")
		str="PyMLabPlugin\n-File: "+__file__+"\n"
		str=str+"-VERSION " + __version__+"\n"+"-AUTHOR " + __author__+"\n"
		new_window.View.SetSource(str)
	
    	def OnFinishInit (self,app_window):
		if DEBUG: print 'Py4datPyMLabPlugin.OnFinishInit A'
		self.app_window=app_window
		Mlab_instance =MLab()
		Mlab_instance.appw = self.app_window
		self.variables={"MLab": Mlab_instance }
		self.app_window.Command=''

		self.app_window.menuConfigure=qt.QPopupMenu(self.app_window.menuBar())
		self.app_window.menuBar().insertItem('&Configure',self.app_window.menuConfigure)
		self.app_window.menuConfigure.insertItem('Show Mlab',self.ShowMlab)
		self.app_window.menuConfigure.insertItem('Hide Mlab',self.HideMlab)
		self.splitter=qt.QSplitter(qt.Qt.Vertical,self.app_window)
		# print qt.version
		self.app_window.mdi.reparent(self.splitter,qt.QPoint(0,0))
		self.app_window.setCentralWidget (self.splitter)



		self.app_window.mlab_input=cmdln_QTextEdit(self.app_window.mdi, "PyMLab_input")
		self.app_window.mlab_input.setCaption("PyMLab Window")
		self.app_window.mlab_input.setText("""# write in this window\n
#  Use python syntax, <Shift>+ <Enter> executes the line the curson is in, if no selection is active
# if a selection is active, <Shift>+ <Enter> execute the selection

# to get Help :  \n\nMLab.Help()   # now click your mouse here and type   <Shift>+ <Enter> 
 
 """)
	
		# self.app_window.mlab_input.raise()
		self.app_window.mlab_input.resize(800,400)
		self.app_window.connect(self.app_window.mlab_input,
					qt.PYSIGNAL("cmdln_QTextEdit_execute_sgnl()"),
					self.Execute)

		self.app_window.mlab_log=cmdln_QTextEdit(self.app_window.mdi , "PyMLab_log")
		self.app_window.mlab_log.setCaption("PyMLab LOG Window")
		self.app_window.mlab_log.setMinimumSize(qt.QSize(self.app_window.mlab_log.x(),25))
		self.app_window.mlab_log.setText("DO NOT WRITE HERE. IT'S JUST A LOG WINDOW")

		self.app_window.mlab_input.setBold(1)
		self.app_window.mlab_input.setItalic(1)

		self.app_window.mlab_input.setBold(0)
		self.app_window.mlab_input.setItalic(0)

		self.app_window.mlab_input.setMinimumSize(qt.QSize(self.app_window.mlab_input.x(),25))


		self.ShowMlab()
	              
    	def GetInfoString(self):
        	if DEBUG: print 'Py4datPyMLabPlugin.GetInfoString'
		return "v. "+__version__

    	########################################################
    	### Private methods
    	########################################################

	def ShowMlab(self):
		if DEBUG: print 'Py4datPyMLabPlugin.ShowMlab'
		if self.displayMlab==0:
			self.app_window.mlab_input.show()
			self.app_window.mlab_log.show()
 			self.displayMlab=1

		
	def HideMlab(self):
		if DEBUG: print 'Py4datPyMLabPlugin.HideMlab'
		if self.displayMlab==1:
			self.app_window.mlab_input.hide()
			self.app_window.mlab_log.hide()
			self.displayMlab=0



		
	def Execute(self,command):
		if DEBUG: print 'Py4datPyMLabPlugin.Execute'
		command=str(command)
		if(command == ""): return
		COMMAND = str(command)
		if(command[-1]!="\n"): COMMAND=COMMAND+"\n"
		globs= globals()
		globs.update(self.variables)
		exec( COMMAND , globals(), self.variables)
		self.app_window.mlab_log.append(COMMAND)



class TextView(View):
    def CreateDrawable(self):
        if DEBUG: print 'In TextView.CreateDrawable...'
	self.Drawable= qt.QTextBrowser(self)
        self.Drawable.show()
    def SetSource(self,source):
        if DEBUG: print 'In TextView.SetSource...'
	import types
        if type(source)is types.StringType: self.Drawable.setText(source)
        else: self.Drawable.setSource(source)
        self.Refresh()
    def Save(self,filename):
        if DEBUG: print 'In TextView.Save...'
	open(filename,"w+").write(str(self.Drawable.text()))


plugin=Py4datPyMLabPlugin()

