"""
    Py4datCommandLogPlugin.py
"""
import qt, Command, string,os,time
from PyDVT.Binding import *
from PyDisWindow import Plugin
import ReadEdfFile
import AzimInt

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'

class Py4datEdit(qt.QLineEdit):
	def __init__(self,*args,**keys):
		qt.QLineEdit.__init__(self,*args,**keys)
		self.Last=""
		
	def keyPressEvent(self,e):
		if e.key() == qt.Qt.Key_Up: self.setText(self.Last)
		else: 
			if e.key() == qt.Qt.Key_Return: 
				self.Last=self.text()
				print self.Last
			qt.QLineEdit.keyPressEvent(self,e)

DEBUG=1

class Py4datCommandLogPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'Py4datCommandLogPlugin.OnStartInit'
		self.displayLog=0
		self.inputFiles=[]
		self.variables={}
		return 0

    	def OnInitMenuBar (self,menu_bar):
        	menuFile=menu_bar.children()[0]
        	menuFile.insertSeparator(4)
        	menuFile.insertItem('Save L&og',self.SaveLog,0,-1,4)
    
    	def OnFinishInit (self,app_window):
		if DEBUG: print 'Py4datCommandLogPlugin.OnFinishInit'
		self.app_window=app_window
		self.app_window.Command=''
		self.AddCommandLine()
		print '1################'
		self.app_window.menuConfigure=qt.QPopupMenu(self.app_window.menuBar())
		print '2################'
		self.app_window.menuBar().insertItem('&Configure',self.app_window.menuConfigure)
		self.app_window.menuConfigure.insertItem('Hide Log',self.HideLog,0,-1,1)
		print '3################'
		self.splitter=qt.QSplitter(qt.Qt.Vertical,self.app_window)
		# print qt.version
		self.app_window.mdi.reparent(self.splitter,qt.QPoint(0,0))
		print '4################'
		self.app_window.setCentralWidget (self.splitter)
		self.app_window.log=qt.QTextEdit(self.splitter)
		print '5################'
		self.app_window.log.setBold(1)
		self.app_window.log.setItalic(1)
		self.app_window.log.append('Py4dat Log Window\n')
		self.app_window.log.setBold(0)
		print '6################'
		self.app_window.log.setItalic(0)
		#self.app_window.log.append('Py4dat>')
		self.app_window.log.setReadOnly(1)
		self.app_window.log.setMinimumSize(qt.QSize(self.app_window.log.x(),25))
		print '4################'
		self.ShowLog()
	              
    	def GetInfoString(self):
        	if DEBUG: print 'Py4datCommandLogPlugin.GetInfoString'
		return "v. "+__version__

    	########################################################
    	### Private methods
    	########################################################

	def ShowLog(self):
		if DEBUG: print 'Py4datCommandLogPlugin.ShowLog'
		if self.displayLog==0:
			self.splitter.show()
			self.app_window.log.show()
			self.app_window.menuConfigure.removeItemAt(0)
			self.app_window.menuConfigure.insertItem('Hide Log',self.HideLog,0,-1,1)
			self.displayLog=1
		
	def HideLog(self):
		if DEBUG: print 'Py4datCommandLogPlugin.HideLog'
		if self.displayLog==1:
			self.app_window.log.hide()
			self.app_window.menuConfigure.removeItemAt(0)
			self.app_window.menuConfigure.insertItem('Show Log',self.ShowLog,0,-1,1)
			self.displayLog=0

	def SaveLog(self):
		if DEBUG: print 'Py4datCommandLogPlugin.SaveLog'
		fn=qt.QFileDialog.getSaveFileName(self.app_window.CurPath,'Ascii files (*.txt)',self.app_window,None,qt.QString.null,qt.QString())
		if fn.isEmpty(): return
		filename=str(fn)
		file=open(filename,'w')
		file.write('# Py4dat Log Save'+'\n')
		file.write('# Date:'+ time.asctime() +'\n')
		file.write(str(self.app_window.log.text()))
		file.close()

	def AddCommandLine(self):
		if DEBUG: print 'Py4datCommandLogPlugin.AddCommandLine'
		box=qt.QVBox(self.app_window.statusBar())
		self.app_window.statusBar().addWidget(box,0,1)
		box1 = qt.QHBox( box )
		lab1=qt.QLabel(box1)
		lab1.setText("Enter command: >")
		self.app_window.ed1=Py4datEdit(box1)
		self.app_window.connect(self.app_window.ed1,qt.SIGNAL("returnPressed()"),self.CommandRegister)
		box.resize( 800, 60 )
		print '###############'

	def LastCommand(self):
		if DEBUG: print 'Py4datCommandLogPlugin.LastCommand'
		print 'LastCommand:',self.app_window.Command
		self.app_window.ed1.setText(self.app_window.Command)
		
	def CommandRegister(self):
		if DEBUG: print 'Py4datCommandLogPlugin.CommandRegister'
		self.app_window.Command=str(self.app_window.ed1.text())
		print self.app_window.Command
		self.Execute(self.app_window.Command)
		if hasattr(self.app_window,'log'): 
			#self.app_window.log.append(self.app_window.Command + '\nPy4dat> ' )
			self.app_window.log.append('Command line action:' + self.app_window.Command)
		self.app_window.ed1.clear()
		
	def Execute(self,command):
		if DEBUG: print 'Py4datCommandLogPlugin.Execute'
		COMMAND=string.upper(command)
		action = string.split(COMMAND,' ')
		if string.count(action[0],'=')!=0:
			var=string.split(action[0],'=')[0]
			val=string.split(action[0],'=')[1]
			self.variables[var]=val
			print self.variables
		if action[0]=='QUIT' or  action[0]=='EXIT': qt.qApp.closeAllWindows()
		#elif action[0]=='IMPORT': pass
		elif action[0]=='INPUTFILE': 
			if len(action)==1: print self.inputFiles
			else: self.inputFiles.append(string.lower(action[1]))
		elif action[0]=='INTEGRATE':
			i=0
			while i<len(self.inputFiles):
				print self.inputFiles[i],type(self.inputFiles[i])
				groupnode=ReadEdfFile.ReadEdfFileGroupNode(self.inputFiles[i])
				print groupnode,groupnode.getChildren().keys()[0]
				dataSetNode=groupnode.getChild(groupnode.getChildren().keys()[0])
				print dataSetNode
				intdatasetnode=AzimInt.AzimIntDataSetNode(dataSetNode,pixelsize=(0.01, 0.01),offset=(0.0, 0.0),center=(256, 256))
				print intdatasetnode
				i=i+1
		else: 	
			try: 
				# exec command in self.variables
				exec( command , self.variables, self.variables)
			except: print 'Command unknown'		


plugin=Py4datCommandLogPlugin()

