import string,time,types,Numeric

from PyDisWindow import Plugin
from PyDVT.ImageView import ImageView, ColormapFilter
from PyDVT.EdfFileData import EdfFileData
from PyDVT.FitFilter import FitFilter
import PyDVT.DataSelection as DataSelection
from DataWrapper import DataToGroupNode
from SciDXPData import SciDXPData
from scidxp.util import DefaultArray
from ReadMccdFile import ReadMccdFileGroupNode
from AzimInt import AzimIntDataSetNode
from AzimIntFilter import AzimIntFilter
from IntegratePhiFilter import IntegratePhiFilter
from Integration import IntegrationDataSetNode
from AddConstantFilter import AddConstantFilter
from MultiplyByConstantFilter import MultiplyByConstantFilter
from SubstractBackgroundFilter import SubstractBackgroundFilter
from LeftRightFlipFilter import LeftRightFlipFilter
from TopBottomFlipFilter import TopBottomFlipFilter

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '03/10/2002'

DEBUG=0

class Py4datAsciiPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datAsciiPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datAsciiPlugin.OnFinishInit...'
		self.app_window=app_window
	
	def OnFileSave (self,window,filename,format_string):
        	if DEBUG: print 'In Py4datAsciiPlugin.OnFileSave...'
		sourceWindow=self.GetSourceWindow(window)
		azimWindow=self.app_window.GetWindow('AzimInt - '+ sourceWindow.name)
		if azimWindow==None : azimWindow=self.app_window.GetWindow('AzimInt - Transformed - '+ sourceWindow.name)
		print 'initialFile=',sourceWindow.name,'\n','destinationFile=',filename
		file=open(filename,'w')
		file.write('# Py4dat Ascii Save for Graph Views'+'\n')
		file.write('# Date:'+ time.asctime() +'\n')
		file.write('# Parameters:'+'\n')
		file.write('#   CenterXY:'+str(sourceWindow.center)+'\n')
		file.write('#   OffsetXY:'+str(sourceWindow.offset)+'\n')
		file.write('#   PixelXY:'+str(sourceWindow.pixelsize)+'\n')
		file.write('#   Wavelength: '+str(sourceWindow.wavelength)+'\n')
		file.write('#   Distance: '+str(sourceWindow.distance)+'\n')
		if azimWindow!=None:
			ret=[]
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			for roi in azimWindow.rois.keys():
				ret.append(azimWindow.rois[roi])
			Limitsx = [ret[0].Limitsx[0]]
			Limitsy = [ret[0].Limitsy[0]]
			ROIx=Limitsx[0]
			ROIy=Limitsy[0]
			file.write('#   ROIx:'+str(ROIx)+'\n')
			file.write('#   ROIy:'+str(ROIy)+'\n')
			if string.count(window.name,'Transformed')!=0:
				i=0
				file.write('#   Transformation: ')
				while i<len(sourceWindow.Transformation):
					file.write(str(sourceWindow.Transformation[i][0:2]) + ' ')
					i=i+1 
				file.write('\n')
			if hasattr(sourceWindow,'Mask') and type(sourceWindow.Mask) != types.NoneType: 
				file.write('#   Masked image \n')
	
		if sourceWindow.shortName=='Stack':
			if azimWindow==None:
				print 'Do Azim Int and select Rois !........'
				return
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			image=0
			while image < sourceWindow.NumImages:	
				file.write('###########################################\n')
				file.write('# File:' + sourceWindow.fileName[image] + '\n')
				if sourceWindow.fileName[image][-3:]=='edf':
					data=EdfFileData()
					data.SetSource(sourceWindow.fileName[image])
					data.LoadSource()
				elif sourceWindow.fileName[image][-4:]=='mccd':
					inputGroupNode=ReadMccdFileGroupNode(sourceWindow.fileName[image])
					data=SciDXPData()
					data.SetSource(inputGroupNode)
					data.LoadSource()
				if hasattr(sourceWindow,'Mask') and type(sourceWindow.Mask) != types.NoneType:
					data.Pages[0].Array=data.GetPageArray()*sourceWindow.Mask
				dataSelection=DataSelection.RectSelection(data)
				if string.count(window.name,'Transformed')!=0:
					i=0
					while i<len(sourceWindow.Transformation):
						if sourceWindow.Transformation[i][0]=='ADD': dataSelection=ColormapFilter(None,AddConstantFilter(dataSelection,buffer_input=1, Constant=sourceWindow.Transformation[i][1]))
    						elif sourceWindow.Transformation[i][0]=='MULTIPLY': dataSelection=ColormapFilter(None,MultiplyByConstantFilter(dataSelection,buffer_input=1, Constant=sourceWindow.Transformation[i][1]))
						elif sourceWindow.Transformation[i][0]=='BKG': dataSelection=ColormapFilter(None,SubstractBackgroundFilter(dataSelection,buffer_input=1, Constant=sourceWindow.Transformation[i][1],BackgroundOutput=sourceWindow.Transformation[i][2]))	
						elif sourceWindow.Transformation[i][0]=='LRFLIP': dataSelection=ColormapFilter(None,LeftRightFlipFilter(dataSelection,buffer_input=1))
						elif sourceWindow.Transformation[i][0]=='TBFLIP': dataSelection=ColormapFilter(None,TopBottomFlipFilter(dataSelection,buffer_input=1))
						i=i+1
				azimFilter=AzimIntFilter(dataSelection,pixelsize=sourceWindow.pixelsize,offset=sourceWindow.offset,center=sourceWindow.center)
				azimData=azimFilter.GetOutput()['data']
				newRois={}
				#############################
				# If tracking enable, the rois have to be adapted to find the peak
				# R Tracking:
				if hasattr(self.app_window,'RTrackingFlag') and self.app_window.RTrackingFlag==1:
					print 'R TRACKING..............'
					step=self.app_window.RTrackingStep
					width=self.app_window.RTrackingWidth
					newROI0=max(ROIx[0]-width,0)
					ROI0List=[]
					integrationList=[]
					while newROI0 < min(ROIx[0]+width, azimData.shape[1]-(ROIx[1]-ROIx[0])):
						ROI0List.append(newROI0)
						newIntegration = Numeric.add.reduce(Numeric.add.reduce(azimData[int(ROIy[0]):int(ROIy[1]),int(newROI0):int(newROI0+ROIx[1]-ROIx[0])],1))
						integrationList.append(newIntegration)
						print 'ROI0 x:',int(newROI0), 'Integration:', newIntegration
						newROI0=newROI0+step
					integrationMax=max(integrationList)
					oldIntegration = Numeric.add.reduce(Numeric.add.reduce(azimData[ROIy[0]:ROIy[1],ROIx[0]:ROIx[1]],1))
					print 'integrationMax:',integrationMax, 'old: ', oldIntegration
					index=integrationList.index(integrationMax)
					newROI=(ROI0List[index],ROI0List[index]+ROIx[1]-ROIx[0])
					newRois['ROIx']=newROI
					file.write('# New ROIx after peak tracking:')
					file.write(str(newROI)+'\n')
				# Phi tracking:
				if hasattr(self.app_window,'PhiTrackingFlag') and self.app_window.PhiTrackingFlag==1:
					print 'PHI TRACKING..............'
					step=self.app_window.PhiTrackingStep
					width=self.app_window.PhiTrackingWidth
					newROI0=max(ROIy[0]-width,0)
					ROI0List=[]
					integrationList=[]
					while newROI0 < min(ROIy[0]+width, azimData.shape[1]-(ROIy[1]-ROIy[0])):
						ROI0List.append(newROI0)
						if newRois.has_key('ROIx'): newIntegration = Numeric.add.reduce(Numeric.add.reduce(azimData[int(newROI0):int(newROI0+int(ROIy[1])-int(ROIy[0])), int(newRois['ROIx'][0]):int(newRois['ROIx'][1])],1))
						else:	newIntegration = Numeric.add.reduce(Numeric.add.reduce(azimData[int(newROI0):int(newROI0+int(ROIy[1])-int(ROIy[0])), int(ROIx[0]):int(ROIx[1])],1))
						integrationList.append(newIntegration)
						print 'ROI0 y:',newROI0, 'Integration:', newIntegration
						newROI0=newROI0+step
					integrationMax=max(integrationList)
					print 'integrationMax:',integrationMax, 'old: ', oldIntegration
					index=integrationList.index(integrationMax)
					newROI=(ROI0List[index],ROI0List[index]+ROIy[1]-ROIy[0])
					newRois['ROIy']=newROI
					file.write('# New ROIy after peak tracking:')
					file.write(str(newROI)+'\n')
					
				#############################
				iphiFilter=IntegratePhiFilter('',azimFilter,parentWindow=azimWindow,newRois=newRois)
				xdata=iphiFilter.GetOutput()['xdata']
				ydata=iphiFilter.GetOutput()['data']
				if hasattr(window,'fit_filter') and type(window.fit_filter) != types.NoneType:
					fit_filter=FitFilter(iphiFilter)
					fit_filter.SetParameters(window.fit_filter.GetParameters())
					yfit=fit_filter.GetOutput()['data']
					file.write('# Fit Parameters:' + str(window.fit_filter.GetParameters()) + '\n')
					file.write('# Xdata' + '    /    ' + 'Ydata' + '    /    ' + 'Yfit' + '\n')
					i=0
					while i < len(ydata) :
						file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '    ' + str(yfit[i])+ '\n')
						i=i+1
				else:
					file.write('# Xdata' + '    /    ' + 'Ydata' + '\n')
					i=0
					while i < len(ydata) :
						file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '\n')
						i=i+1
				image=image+1
			file.close()
		else:
			if window==None or isinstance(window.View,ImageView) == 1 :
				print 'The active window must be a GraphView...........'
				return
			file.write('###########################################\n')
			file.write('# File:' + window.name + '\n')
			xdata=window.View.GetSource()[0].GetOutput()['xdata'].tolist()
			ydata=window.View.GetSource()[0].GetOutput()['data'].tolist()
			file.write('# Xdata' + '    /    ' + 'Ydata' + '\n')
			i=0
			while i < len(xdata) :
				file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '\n')
				i=i+1
			file.close()	

		
	def GetSaveFormatList(self,window):
        	if DEBUG: print 'In Py4datAsciiPlugin.GetSaveFormatList...'
		return ["Ascii files (*.txt)"]

	def GetInfoString(self):
		return "v. "+__version__

    	########################################################
    	### Private
    	########################################################

    	def GetSourceWindow(self,window):
    		if window==None: return
		while window.master_window!=None:
			window=window.master_window
		return window
	
				
plugin=Py4datAsciiPlugin()
