"""
    TrackingParametersDialog.py
    
"""
from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='20/11/2002'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'


class TrackingParametersDialog(QMainWindow):
	def __init__(self, parent,initial_parameters):
        	QMainWindow.__init__(self,parent,"Tracking Parameters Editor",0)  

		self.dlg=Dialog(self,"Tracking Parameters",1,0)
        	box=QVBox( self.dlg )
		self.RTrackingFlag=initial_parameters['RTrackingFlag']
		self.RTrackingWidth=initial_parameters['RTrackingWidth']
		self.RStep=initial_parameters['RStep']
		self.PhiTrackingFlag=initial_parameters['PhiTrackingFlag']
		self.PhiTrackingWidth=initial_parameters['PhiTrackingWidth']
		self.PhiStep=initial_parameters['PhiStep']
		
		box0 = QHBox( box )
        	box1 = QHBox( box )
        	box2 = QHBox( box )
        	box3 = QHBox( box )
        	box4 = QHBox( box )
        	box5 = QHBox( box )
        	box6 = QHBox( box )
		
		self.Rcheck=QCheckBox(box0)
        	lab1=QLabel(box1)
        	self.ed1=QLineEdit(box1)
        	lab2=QLabel(box2)
        	self.ed2=QLineEdit(box2)
		self.Phicheck=QCheckBox(box3)
        	lab3=QLabel(box4)
        	self.ed3=QLineEdit(box4)
        	lab4=QLabel(box5)
        	self.ed4=QLineEdit(box5)
		
		if self.RTrackingFlag==0:
			self.ed1.setReadOnly(1)
			self.ed2.setReadOnly(1)
			self.ed3.setReadOnly(1)
			self.ed4.setReadOnly(1)
		   
		self.Rcheck.setText("Enable R Tracking")
		self.Rcheck.setChecked(self.RTrackingFlag)
		self.Rcheck.setFixedWidth(200)
		self.Phicheck.setText("Enable Phi Tracking")
		self.Phicheck.setChecked(self.PhiTrackingFlag)
		self.Phicheck.setFixedWidth(200)
		
        	lab1.setText("R Tracking Width")
	 	lab1.setFixedWidth(110)
        	self.ed1.setText(QString(str(self.RTrackingWidth)))
		self.ed1.setFixedWidth(80)
        	lab2.setText("R Step")
		lab2.setFixedWidth(110)
        	self.ed2.setText(QString(str(self.RStep)))
		self.ed2.setFixedWidth(80)
		
		lab3.setText("Phi Tracking Width")
	 	lab3.setFixedWidth(110)
        	self.ed3.setText(QString(str(self.PhiTrackingWidth)))
		self.ed3.setFixedWidth(80)
        	lab4.setText("Phi Step")
		lab4.setFixedWidth(110)
        	self.ed4.setText(QString(str(self.PhiStep)))
		self.ed4.setFixedWidth(80)
		
        	button=QPushButton(box6)
        	button.setText("OK")
		button.setFixedWidth(80)
		CancelButton=QPushButton(box6)
		CancelButton.setFixedWidth(80)
        	CancelButton.setText("Cancel")
        	
		self.connect(self.Rcheck,SIGNAL("clicked()"),self.RStateChange)
		self.connect(self.Phicheck,SIGNAL("clicked()"),self.PhiStateChange)
		self.connect(button,SIGNAL("clicked()"),self.dlg.accept)
		self.connect(CancelButton,SIGNAL("clicked()"),self.dlg.reject)
        	box.resize( 230, 220 )
        	if self.dlg.exec_loop():
            		try:
				self.RTrackingFlag=self.Rcheck.isChecked()
				self.RTrackingWidth=float(str(self.ed1.text()))
				self.RStep=float(str(self.ed2.text()))
				self.PhiTrackingFlag=self.Phicheck.isChecked()
				self.PhiTrackingWidth=float(str(self.ed3.text()))
				self.PhiStep=float(str(self.ed4.text()))
            		except: pass
	
	def RStateChange(self):
		if self.Rcheck.isChecked():
			self.ed1.setReadOnly(0)
			self.ed2.setReadOnly(0)
		else:
			self.ed1.setReadOnly(1)
			self.ed2.setReadOnly(1)
	
	def PhiStateChange(self):
		if self.Phicheck.isChecked():
			self.ed3.setReadOnly(0)
			self.ed4.setReadOnly(0)
		else:
			self.ed3.setReadOnly(1)
			self.ed4.setReadOnly(1)		

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=TrackingParametersDialog(None,{'RTrackingFlag':0,'RTrackingWidth':.1,'RStep':.01,'PhiTrackingFlag':0,'PhiTrackingWidth':.1,'PhiStep':.01})
    app.setMainWidget (win)
    app.exec_loop()

