import qt,saxs,array
from Numeric import *
from PyDVT.ExtendedImageView import *
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import ReadEdfFile
import PyDVT.ImageView as ImageView
import PyDVT.GraphView as GraphView
from ErrorWindow import ErrorWindow

DEBUG=0

class IntegratePhiFilter(GraphFilter):
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=0,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none",parentWindow=None,newRois={}):
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
		self.parentWindow=parentWindow
		self.newRois=newRois
	
	def GetOutput(self):
		if DEBUG: print 'In IntegratePhiFilter.GetOutput...'
		
		sel=self.GetInput()
		
		image=sel['data']	
				
		if len(self.parentWindow.rois.keys())!=1:
			print self.parentWindow.rois.keys()
			dial=ErrorWindow(None,message=' You must select 1 ROI before integrate !',sizex=237,sizey=60)
			return {}
		else:
			ret=[]
			for roi in self.parentWindow.rois.keys():
				ret.append(self.parentWindow.rois[roi])
			print 'number of ROIs:',len(ret)
			#Limitsx = [ret[0].Limitsx[0],ret[1].Limitsx[0],ret[2].Limitsx[0]]
			#Limitsy = [ret[0].Limitsy[0],ret[1].Limitsy[0],ret[2].Limitsy[0]]
			Limitsx = [ret[0].Limitsx[0]]
			Limitsy = [ret[0].Limitsy[0]]
			#Limitsx.sort()
			ROIx,ROIy=Limitsx[0],Limitsy[0]
			#ROIx,ROIy=Limitsx[1],Limitsy[1]
			#BKG1x,BKG1y=Limitsx[0],Limitsy[0]
			#BKG2x,BKG2y=Limitsx[2],Limitsy[2]
			
			if self.newRois.has_key('ROIx'): ROIx=self.newRois['ROIx']
			if self.newRois.has_key('ROIy'): ROIy=self.newRois['ROIy']
			
          		x1, x2 = ROIx[0],ROIx[1]
			#x3, x4 = BKG1x[0],BKG1x[1]
			#x5, x6 = BKG2x[0],BKG2x[1]
			y1, y2 = ROIy[0],ROIy[1]
			#y3, y4 = BKG1y[0],BKG1y[1]
			#y5, y6 = BKG2y[0],BKG2y[1]
          		ROI = Numeric.sum(image[int(y1):int(y2),int(x1):int(x2)],1)
            		#BKG1 = Numeric.sum(image[int(y3):int(y4),int(x3):int(x4)],1)
          		#BKG2 = Numeric.sum(image[int(y5):int(y6),int(x5):int(x6)],1)
        		#if len(BKG1) == len(BKG2):
         		#	BKG = BKG1 + BKG2
        		#else:
          		#	BKG = BKG1
        		#integrated_arr = ROI - BKG
			integrated_arr = ROI
			
      			xdata=arange(0,integrated_arr.shape[0],1)			
			return {'name': self.name,'data': integrated_arr,'xdata': xdata,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
			
		
	
