import qt,saxs,array
from Numeric import *		# -> array
from scidxp.util import *
from PyDVT.Filter import *


DEBUG=0

class AzimIntFilter(Filter):
	def __init__(self,source,synchronized=1,buffer_input=0,pixelsize=(0.01,0.01),offset=(0.0,0.0),center=(256,256)):
		Filter.__init__(self,source,synchronized,buffer_input)
		self.pixelsize=pixelsize
		self.offset=offset
		self.center=center
	
	def GetOutput(self):
		if DEBUG: print 'In AzimIntFilter.GetOuput...'		
		sel=self.GetInput()		
		data=sel['data']
	
		saxs.set_pixelsize(self.pixelsize[0],self.pixelsize[1])
		saxs.set_offset(self.offset[0],self.offset[1])
		saxs.set_center(self.center[0],self.center[1])
		
		#saxs.set_pixelsize(0.01, 0.01)
		#saxs.set_offset(0.0, 0.0)
		#saxs.set_center(data.shape[0]/2., data.shape[1]/2.)

		image = data.astype(Numeric.Float32)

		out_image =array((image))
		saxs.azim_int(image, out_image, 0, -1, 0, 359, 1)
		out_image = out_image[0:360, 0:1200]
		return {'data':out_image}
