"""
    Drawable3D.py
    3D plotting of 2D arrays 
        
"""

from PyDVT import __version__,__date__,__author__


import Tkinter
import pyqt_pl 
import mytkplplot
import Numeric
from Binding import Pen,Brush


class  Drawable_3D(Tkinter.Frame):
    def __init__( self,parent=None,**kw):
       self.parent=parent
       Tkinter.Frame.__init__(self,parent,**kw)
       self.parent.Show()
       self.grid(row=0,col=0,sticky="nsew")
       self.qpl=  mytkplplot.MyTkplplot(self,back_color=( 0xFF, 0xFF, 0xFF ))
       
       self.VScroll=Tkinter.Scrollbar(self.parent,orient=Tkinter.VERTICAL)
       self.HScroll=Tkinter.Scrollbar(self.parent,orient=Tkinter.HORIZONTAL)
       
       self.TrackScrollBars =0 
       self.VScroll.configure(command=self.vmove)
       self.HScroll.configure(command=self.hmove)
       self.ViewAltitude=60.0
       self.ViewAzimuth=30.0       
       self.sethscroll(self.ViewAzimuth)
       self.setvscroll(self.ViewAltitude)
       self.TrackScrollBars =0
       self.VScroll.bind("<ButtonRelease-1>", self.vchange)
       self.HScroll.bind("<ButtonRelease-1>", self.hchange)
      
       self.GraphicObjects=[]        
              
       self.init=1
       self.style="3dSurface"
       self.MeshMode=1
       self.log=0
       self.functions={}       
       self.SetEnv(0,1000,0,1000,0,1000)       
       self.TitleLabel=self.XLabel=self.YLabel=self.ZLabel=""


        
    def Show(self):
        self.VScroll.grid(row=0,col=1,sticky="ns")
        self.HScroll.grid(row=1,col=0,sticky="ew")
        self.qpl.pack(expand=Tkinter.YES, fill=Tkinter.BOTH)

    def RemoveFunction(self,name=None):
        if name==None:
            self.functions={}
        else:
            if name in self.functions.keys():  del self.functions[name]
            
    def SetFunction(self,name,function_pars):
        self.functions[name]=function_pars

    def SetFunctionItem(self,name,item,val):
        if name in self.functions.keys():
            self.functions[name][item]=val

    def SetLabels(self,title_label="",x_label="",y_label="",z_label=""):
        self.TitleLabel,self.XLabel,self.YLabel,self.ZLabel=title_label,x_label,y_label,z_label

    def SetEnv(self,xmin,xmax,ymin,ymax,zmin,zmax):   
       (self.xmin,self.xmax,self.ymin,self.ymax,self.zmin,self.zmax)=(xmin,xmax,ymin,ymax,zmin,zmax)


    def SetTrackScrollbars(self,value):
       if self.TrackScrollBars != value:
           if self.TrackScrollBars:
               self.TrackScrollBars =0
               self.VScroll.bind("<ButtonRelease-1>", self.vchange)
               self.HScroll.bind("<ButtonRelease-1>", self.hchange)
           else: 
               self.TrackScrollBars =1
               self.VScroll.unbind("<ButtonRelease-1>")
               self.HScroll.unbind("<ButtonRelease-1>")
       self.TrackScrollBars = value


    def hmove(self, *args):
        if args[0]=='moveto':
            pos= float(args[1])
        elif args[0]=='scroll':
            (lo, hi)= self.HScroll.get()
            if args[2]=='pages': pos= lo+(0.1*int(args[1]))
            else:                pos= lo+(0.05*int(args[1]))
        else:
            return
        pos=min(max(pos,0),0.9)        
        self.HScroll.set(pos, pos+0.1)
        self.ViewAzimuth=float(pos*270./0.9)
        self._Refresh(self.TrackScrollBars)


    def vmove(self, *args):
        if args[0]=='moveto':
            pos= float(args[1])
        elif args[0]=='scroll':
            (lo, hi)= self.VScroll.get()
            if args[2]=='pages': pos= lo+(0.1*int(args[1]))
            else:                pos= lo+(0.05*int(args[1]))
        else:
            return
        pos=min(max(pos,0),0.9)        
        self.VScroll.set(pos, pos+0.1)
        self.ViewAltitude=float(pos*90./0.9)
        self._Refresh(self.TrackScrollBars)

    def hchange(self,*args):
        (lo, hi)= self.HScroll.get()
        pos=min(max(lo,0),0.9)
        self.ViewAzimuth=float(pos*270./0.9)
        self._Refresh(1)


    def vchange(self,*args):
        (lo, hi)= self.VScroll.get()
        pos=min(max(lo,0),0.9)
        self.ViewAltitude=float(pos*90./0.9)
        self._Refresh(1)


    def sethscroll(self,pos):
        x1=pos*0.9/270
        x2=x1+0.1
        self.HScroll.set(x1, x2)
        
    def setvscroll(self,pos):
        x1=pos*0.9/90
        x2=x1+0.1
        self.VScroll.set(x1, x2)
  

    def SetStyle(self,style):
      if style != self.style:
         self.style=style
         self._Refresh(1)
         

    def SetMeshPlottingMode(self,mode):
      if mode=="XLines":mode=2
      elif mode=="Both":mode=3
      else: mode=1
      
      if self.MeshMode!=mode:
         self.MeshMode=mode
         self._Refresh(1)

    def Linear( self ):
      if self.log:
         self.log=0
         self._Refresh(1)

    def Log( self,minvalue=0.000001):
      self.minvaluelog=minvalue 
      if self.log==0:
         self.log=1
         self._Refresh(1)      

    def Redraw(self):
        #self.GraphicObjects=[]        
        self._Refresh()

    def _DrawFunctions(self,modpl,draw_function=1):
         modpl.pladv(0)         
         modpl.plrgb1(0,0,0)
         #plwind(-1.0, 1.0, -0.9, 1.1)
         if self.TitleLabel != "":
            modpl.plvpor(0.0, 1.0, 0.0, 0.9)
         else:
            modpl.plvpor(0.0, 1.0, 0.0, 1.0)
         modpl.plwind(-1.0, 1.0, -0.75, 1.25)

         if self.log:
               minval,maxval=self.zmin,self.zmax
               if minval<=0: minval=self.minvaluelog
               if maxval<=minval: maxval=minval+0.000001
               modpl.plw3d(1.0, 1.0, 1.0, self.xmin,self.xmax,self.ymin,self.ymax,Numeric.log10(minval),Numeric.log10(maxval), self.ViewAltitude,self.ViewAzimuth)
               modpl.plbox3("bnstu",self.XLabel, 0.0, 0,
                "bnstu", self.YLabel, 0.0, 0,
                 "bcdlmnstuv", self.ZLabel, 0.0, 0)                              
         else:
             modpl.plw3d(1.0, 1.0, 1.0, self.xmin,self.xmax,self.ymin,self.ymax,self.zmin,self.zmax, self.ViewAltitude,self.ViewAzimuth)
             modpl.plbox3("bnstu", self.XLabel, 0.0, 0,
              "bnstu", self.YLabel, 0.0, 0,
              "bcdmnstuv", self.ZLabel, 0.0, 0)
         
         if self.TitleLabel != "": modpl.plmtex("t", 1.5, 0.5, 0.5, self.TitleLabel)

         if draw_function:         
             for function in  self.functions.values():
                func=(function["data"])             
                if func.shape[0] != 0 and func.shape[1] != 0:
                    if self.log:
                       func=Numeric.maximum(func,minval)               
                       func=Numeric.log10(func)
                    pen=function["pen"]
                    modpl.plrgb1(pen.color[0],pen.color[1],pen.color[2])
                    #3d Surface
                    if self.style=="3dSurface":
                      modpl.plot3d(function["xdata"], function["ydata"], Numeric.transpose(func), self.MeshMode, 0)
                    #Mesh Surface
                    elif self.style=="SurfaceMesh":
                      modpl.plmesh(function["xdata"], function["ydata"], Numeric.transpose(func), self.MeshMode)
                    #Shaded 3d Surface
                    else:
                      self.qpl.set_cmap1_rgb(modpl,pen.color)
                      modpl.plotsh3d(function["xdata"], function["ydata"], Numeric.transpose(func), 0)



    def _Refresh(self,draw_function=1):
         self.qpl.InitDrawing()
         self._DrawFunctions(pyqt_pl,draw_function)
         self.qpl.EndDrawing()


    def Save(self,filename,format="BMP"):
        import pl
        pl.plsdev("psc")
        pl.plsfnam(filename)
        pl.plscolbg(self.qpl.back_color[0],self.qpl.back_color[1],self.qpl.back_color[2])        
        pl.plinit()
        self._DrawFunctions(pl,1)
        pl.plend()
        if format=="PS": return
        if format=="JPG": format="JPEG"
        else:
            try:
                import Image
                pilim=Image.open(filename).transpose(Image.ROTATE_270)
                pilim.save(filename,format)
            except:
                import os
                try: os.remove(tmpfile)
                except: pass
                return 0


    def Destroy(self):
        self.parent=None
        self.qpl=  None
        self.functions={}
        self.GraphicObjects=[]        
        self.VScroll=None
        self.HScroll=None
                     
    def _RightButtonPress(self,event):
        if self.parent is not None: self.parent._RightButtonPress(event)

    def _LeftButtonPress(self, e):
        pass

    def _LeftButtonRelease(self, e):
        pass
            
    def _Motion(self, e):
        pass

    def _PressMotion(self,e):
        pass

    def _DoubleClick(self, e):
        pass
		
    def _KeyPress(self,e):
        pass
