/****************************************************************************

                     uMatrix C++ Matrix Library

    Copyright (C) 1996  David Weber, Michael Sipe and Rajesh Shenoy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    David Weber can be contacted at weber@ece.cmu.edu or 
    http://www.ece.cmu.edu/afs/ece/usr/weber/.home-page.html

****************************************************************************/

#include <iostream.h>
#include <math.h>
#include <complex.h>
#include <nVector.h>
#include <nMatrix.h>
#include <fftpack.h>

#ifndef PI
#define PI 3.14159265359
#endif

class fComplexFFT1d
{
   private:
      float *fftStorage;
      int N;

   public:
      fComplexFFT1d( const int Size ); // Constructor
      inline ~fComplexFFT1d() { if (N) delete [] fftStorage; } 
      inline  fComplexFFT1d( ) {N=0; };
      void forward( uVector<fComplex>& data );
      void inverse( uVector<fComplex>& data );
};

class fComplexFFT2d
{
   private:
      float *fftStorageN, *fftStorageM;
      int N,M;

   public:
      fComplexFFT2d( const int SizeN, const int SizeM ); // Constructor
      inline ~fComplexFFT2d() { delete [] fftStorageN; delete [] fftStorageM; }
      void forward( uMatrix<fComplex>& data );
      void inverse( uMatrix<fComplex>& data );
      void flip( uMatrix<fComplex>& data );
};

class RealFFT2d
{
   private:
      float *fftStorageN, *fftStorageM;
      int N,M;

   public:
      RealFFT2d( const int SizeN, const int SizeM ); // Constructor
      inline ~RealFFT2d() { delete [] fftStorageN; delete [] fftStorageM; }
      void forward( uMatrix<fComplex>& data );
      void inverse( uMatrix<fComplex>& data );
      void flip( uMatrix<fComplex>& data );
};

/*
   Double precision FFT drivers
*/ 

class ComplexFFT1d
{
   private:
      double *fftStorage;
      int N;

   public:
      ComplexFFT1d( const int Size ); // Constructor
      inline ComplexFFT1d() { N=0; } 
      inline ~ComplexFFT1d() { if(N) delete [] fftStorage; }
      void forward( uVector<Complex>& data );
      void inverse( uVector<Complex>& data );
};

class ComplexFFT2d
{
   private:
      double *fftStorageN, *fftStorageM;
      int N,M;

   public:
      ComplexFFT2d( const int SizeN, const int SizeM ); // Constructor
      inline ~ComplexFFT2d() { delete [] fftStorageN; delete [] fftStorageM; }
      void forward( uMatrix<Complex>& data );
      void inverse( uMatrix<Complex>& data );
      void flip( uMatrix<Complex>& data );
};

class doubleRealFFT2d
{
   private:
      double *fftStorageN, *fftStorageM;
      int N,M;

   public:
      doubleRealFFT2d( const int SizeN, const int SizeM ); // Constructor
      inline ~doubleRealFFT2d() { delete [] fftStorageN; delete [] fftStorageM; }
      void forward( uMatrix<Complex>& data );
      void inverse( uMatrix<Complex>& data );
      void flip( uMatrix<Complex>& data );    
};

void convolve( uMatrix<fComplex>& image, const uMatrix<fComplex>& filter );
void convolve( uMatrix<Complex>& image, const uMatrix<Complex>& filter );



