/****************************************************************************

                     uMatrix C++ Matrix Library

    Copyright (C) 1996  David Weber, Michael Sipe and Rajesh Shenoy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    David Weber can be contacted at weber@ece.cmu.edu or 
    http://www.ece.cmu.edu/afs/ece/usr/weber/.home-page.html

****************************************************************************/

#ifndef uMath_included
#define uMath_included

/*
   Implementation of element for element math functions. Note that this
   implements all of the float and double math functions that take a single
   argument (atan2 and pow etc. are excluded). Currently, all Complex math
   functions supported by Libg++-2.7.0 are supported. This is based on 
   code originally contributed by Neil Gerrans. Dave Weber implemented it 
   as macros and incorporated it into the uMatrix fold.
*/

#include <math.h>
#include "nMatrix.h"

// Contributed by Neil Gerrans
#define mathDeclMacro(mathFunc)\
template <class Type>\
uMatrix<Type> mathFunc( const uMatrix<Type>& data)	\
{						\
   uMatrix<Type> A(data.rows(),data.columns());	\
   Type *a = (Type *) A.address();		\
   Type *d = (Type *) data.address();		\
   for ( int i = 0; i < data.rows()*data.columns(); i++ ) \
   {						\
     *a++ = mathFunc(*d++);			\
   }						\
   A.markAsTemporary();				\
   return A;					\
}\

mathDeclMacro(sqrt);
mathDeclMacro(log);
mathDeclMacro(exp);
mathDeclMacro(cos);
mathDeclMacro(sin);
mathDeclMacro(sinh);
mathDeclMacro(cosh);

// Stuff that only works for real types
mathDeclMacro(tan);
mathDeclMacro(atan);
mathDeclMacro(log10);
mathDeclMacro(floor);
mathDeclMacro(ceil);
mathDeclMacro(tanh);
mathDeclMacro(acos);
mathDeclMacro(asin);

#endif


