/****************************************************************************

                     uMatrix C++ Matrix Library

    Copyright (C) 1996  David Weber, Michael Sipe and Rajesh Shenoy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    David Weber can be contacted at weber@ece.cmu.edu or 
    http://www.ece.cmu.edu/afs/ece/usr/weber/.home-page.html

****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern int cfftb_(int *n, float *c, float *wsave);
extern int cfftf_(int *n, float *c, float *wsave);
extern int cffti_(int *n, float *wsave);

extern int cosqb_(int *n, float *x, float *wsave);
extern int cosqf_(int *n, float *x, float *wsave);
extern int cosqi_(int *n, float *wsave);

extern int cost_(int *n, float *x, float *wsave);
extern int costi_(int *n, float *wsave);

extern int rfftb_(int *n, float *r, float *wsave);
extern int rfftf_(int *n, float *r, float *wsave);
extern int rffti_(int *n, float *wsave);

extern int sinqb_(int *n, float *x, float *wsave);
extern int sinqf_(int *n, float *x, float *wsave);
extern int sinqi_(int *n, float *wsave);

extern int sint_(int *n, float *x, float *wsave);
extern int sinti_(int *n, float *wsave);

/*
    Double precision prototypes
*/

extern int dcfftb_(int *n, double *c, double *wsave);
extern int dcfftf_(int *n, double *c, double *wsave);
extern int dcffti_(int *n, double *wsave);

extern int dcosqb_(int *n, double *x, double *wsave);
extern int dcosqf_(int *n, double *x, double *wsave);
extern int dcosqi_(int *n, double *wsave);

extern int dcost_(int *n, double *x, double *wsave);
extern int dcosti_(int *n, double *wsave);

extern int drfftb_(int *n, double *r, double *wsave);
extern int drfftf_(int *n, double *r, double *wsave);
extern int drffti_(int *n, double *wsave);

extern int dsinqb_(int *n, double *x, double *wsave);
extern int dsinqf_(int *n, double *x, double *wsave);
extern int dsinqi_(int *n, double *wsave);

extern int dsint_(int *n, double *x, double *wsave);
extern int dsinti_(int *n, double *wsave);

#ifdef __cplusplus
}
#endif



















