  /** La struttura COUCHE, che ha un uso molto limitato, serve
       a passare in argomento n ed l d'un solo colpo ad una
       funzione e semplificare la scrittura del programma */
class COUCHE {
public:
  COUCHE( int nn, int ll) { n=nn;  l=ll; };
  int n,l;
};

/**
 Questa classe rappresnta un livello n,l,mz,sz. Ogni numero quantico
 e' rappresentato dan un byte. Il numero sz e' rappresentato
 da 1 per 0.5 e -1 per -0.5 (logicamente perche un byte
 assume valori interi).

 Svariate funzioni membro o amiche permettono di confrontare
 livelli fra di loro.
*/
class LIVELLO {
public:
  char n; 
  char l;
  char mz;
  char sz;
  /** questo operatore controlla l'uguaglianza fra a e b.
      Il confronto sei esegue per comparazione di zone di memoria
      usando la funzione memcmp.
  */
  friend inline int operator == ( LIVELLO &a, LIVELLO &b);
  /** questo operatore controlla  se  a e maggiore di  b.
      Il confronto sei esegue per comparazione di zone di memoria
      usando la funzione memcmp.
  */
  friend inline int operator  > ( LIVELLO &a, LIVELLO &b);
  /**
   <pre>
     return ( a.l == b.l && a.mz == b.mz &&  a.sz==b.sz  );
    </pre>
  */
  friend inline int stessaparteangolare(LIVELLO &a, LIVELLO &b);

  /**
   <pre>
				return mz >= -l && mz <= l;
   </pre>
  */
  inline int Lis_physical() {return mz>=-l && mz<=l; };
  /**
   <pre>
				return sz==-1 || sz==1;
   </pre>
  */
  inline int Sis_physical() {return sz==-1 || sz==1; };

	/** stampa allo schermo  i numeri quantici
	*/
  inline void  stampa() { printf("n=%d;l=%d;mz=%d;sz=%d\n",n,l,mz,sz); };

  /** Crea livello inizializzandolo con dei numeri quantici non fisici
  */
  inline LIVELLO() {n=-1,l=-1;mz=0;sz=0; };

  /** Crea livello inizializzandolo con i numeri quantici dati in input
  */
  inline LIVELLO(int na, int la, int ma, int sa) {n=na,l=la;mz=ma;sa=0; };


  /** La struttura COUCHE, che ha un uso molto limitato, serve
       a passare in argomento n ed l d'un solo colpo ad una
       funzione e semplificare la scrittura del programma */
  inline COUCHE couche() {return COUCHE(n,l);};

  inline void creatorLIVELLO() {};
  /** serializza sul file f
  */
  void serializza(fichier &f);
};


inline int operator ==(LIVELLO &a, LIVELLO &b)
{
  return ( memcmp(&a,&b, sizeof(LIVELLO))==0);
};



inline int operator > (LIVELLO &a, LIVELLO &b)
{
  int res;
  res=(memcmp(&a,&b, sizeof(LIVELLO))>0);
  return (res );
};

inline int stessaparteangolare(LIVELLO &a, LIVELLO &b)
{
   return ( a.l == b.l && a.mz == b.mz &&  a.sz==b.sz  );
};


/**
  Questa classe e' un'array di livelli.
  Per motivi di rapidita i livelli sono ordinati. La classe
  contiene l'intero segno che serve a tenere traccia della
  permutazione necessaria a portare l'array di livelli in forma
  ordinata.
*/
class DETERMINANTE  {
public:
  DETERMINANTE();
  void creatoreDETERMINANTE() ;
  /** crea un determinante con n elettroni  */
  DETERMINANTE(int n);
  ~DETERMINANTE();
	/** adatta la dimensione dell'array di livelli a n elettroni  */
  void resize(int n);
  /** copia il determinante a */
  void copia(DETERMINANTE &a);

  /** controlla che il livello iesimo non sia presente due volte nell'array */
  int  not_doubly_occuped(int i);
  /** stampa allo schermo la pappardella*/
  void stampa();
  /** ritorna il numero di elettroni */
  inline int getnel() { return nel ; }
  /** ritorna il livello n */
  inline LIVELLO & getlevel(int n) { return livello[n]; }

	
	/** Sempre il prodotto scalare, ma si suppongono che i livelli
	    siano ordinati. Questo accelera di molto la funzione
	*/
  friend double  dotordinato (DETERMINANTE &a , DETERMINANTE &b);
  /**
	   riordina i livelli in modo crescente
  */
  void riordinalivelli();
	

  /**Da 1 se e' possibile passare dal determinante a a quello b con un'interazione
     a due corpi che coinvolge  i gusci ca1, ca2 in a, e cb1 e cb2 in b.
     Altrimenti zero.

     Si suppone che un riordino in a e b sia stato precedentemente fatto.
  */
  friend  int possibileduecorpiordinati(DETERMINANTE &a , DETERMINANTE &b,
				      COUCHE &ca1, COUCHE &ca2, COUCHE &cb1, COUCHE &cb2  );
				
  /** da il numero dei livelli di a che non si trovano in b
    che s uguale a quello dei livelli  di b che non si trovano in a.
	  Le posizioni dei livelli spaiati sono memorizzate negli array ia e ib.
	
     Si suppone che un riordino in a e b sia stato precedentemente fatto.
   */				
  friend int spaiatiordinati(class DETERMINANTE &a, class DETERMINANTE &b, int *ia, int *ib);

	/** torna il numero di livelli spaiati  questa funzione e prevista per
	    il caso multiconfigurazionale in cui a e b possono avere un numero diverso
	    di elettroni
	*/
  friend int  spaiatiordinatimulti(class DETERMINANTE &a, class DETERMINANTE &b, int *, int *, int &nspa, int &nspb,
				  int maxnspa, int maxnspb);
	/**
	   Da 1 se e' possibile passare dal determinante a a quello b con un'interazione
     a un  corpi che coinvolge  i gusci ca  in a, e cb   in b.
     Altrimenti zero
	
     Si suppone che un riordino in a e b sia stato precedentemente fatto.
  */
  friend int possibileuncorpoordinati(class DETERMINANTE &a, class DETERMINANTE &b, class COUCHE &ca, class COUCHE &cb);

  /**
		copia il determinante a
	*/
  inline void operator =(DETERMINANTE &a) {copia(a);};

  /**  da il massimo n e il massimo l dei livelli presenti nel determinante  */
  void get_max_nl(int &n,int &l);
  
	/** Si crea una tavola con lo scopo di risalire alla posizione
	    di un livello cercato nel determinante, conoscendo i numeri quantici
	    n,l,mz,sz.
	
	    Gli argomenti N ed L servono a dimensionare la tavola. Devono essere
	    ottenuti con get_max_nl(int &n,int &l).
			Questa funzione crea unicamente la tavola
	    */
  void creatavola(int N,int L);

  	/** La  tavola serve a risalire alla posizione
	    di un livello cercato nel determinante, conoscendo i numeri quantici
	    n,l,mz,sz.
	
			Questa funzione inizializza la tavola con le buone posizioni la tavola
	    */
  void preparatavola();

  /**
		libera la memoria riservata per la tavola.
  */
  void distruggitavola();
  /**
    ottiene la posizione dello stato avente numeri
    quantici n,l,mz,sz
  */
  inline int gettavola(int n,int l,int mz,int sz)
  {
    return tavola[n][l][mz][sz];
  };

  /**
    ottiene la posizione del livello niv.
    La struttura LIVELLO non e' altro che
    i quattro numeri quantici

    @see LIVELLO
  */

  inline int gettavola(LIVELLO &niv) { 
    return  gettavola(niv.n, niv.l, niv.mz, niv.sz);
  };

  /** serializza il determinante  */
  void serializza(fichier &f);

  /** ottiene il segno associato al determinante  */
  int getsegno() { return segno;};
  void  setsegno(int s) {  segno=s;};

private:
 int nel;
 LIVELLO * livello;
 int **** tavola;
 int segno;
public:
 double preSz;
 double preMz;

};

#define BUFFERDETRESIZEERASE  1
#define BUFFERDETRESIZECOPY   2
/**
   Qesta classe serve a registrare il risultato dell'applicazione di un operatore
   Su un determinante.
	 Il risultato di un operatore su di un determinante e' in generale
	 una combinazione lineare di determinanti.
	
	 Per questo scopo BUFFERDET e' composto da un'array di determinant e di
	 un'array di coefficienti
*/

class BUFFERDET {
public:
  BUFFERDET();
  ~BUFFERDET();
  /** esegue un controllo sulla memoria allocata. Se
      le memoria e' insufficiente:

       - in caso  resize==BUFFERDETRESIZEERASE (che e 1)
         la si distrugge e
         se ne crea al suo posto una quantita sufficiente per nd determinanti
          aventi ne elettroni.

			- in caso  resize==BUFFERDETRESIZECOPY (che e 1)
         se ne crea al suo posto una quantita sufficiente per ne determinanti
          aventi ne elettroni. Prima di distruggere la vecchia la si ricopia
          sulla nuova

      - altrimenti si emette un messaggio di errore e si blocca il programma

          */
  void atleast(int nd, int ne, int resize=1);

  /**  libera tutta la memoria */
  void libera();

  /**  ritorna la referenza al determinante iesimo */
  DETERMINANTE & operator () (int i) ;

  /**  ritorna la referenza al coefficiente del determinante iesimo */
  TIPOFATTORE  & getcoef(int i);



  /**  effettua la somma dei prodotti scalari di a con ognuno
       dei determinanti del buffer moltiplicati per i coefficienti rispettivi.

       Si suppone che a sia ordinato per andare piu veloci
       */
  double scalareordinato(DETERMINANTE &a);

  void aggiungi(DETERMINANTE &s, double fattore);

  /** questo numero dice quanti determinanti compongono il buffer
      Questo numero deve eseere per foza minore del numero massimo
      permesso dalla memoria allocata.*/
  int inuse;
private:
  /** numero massimo dei determinanti che possono essere memorizzati
      Questo numero viene settato da atleast che alloca anche la memoria
      corrispondente*/
  int n_det;
  /** numero di elettroni presenti in ciascuno dei determinanti.
      Questo numero viene settato da  @ref atleast
  */
  int nel;
  /** array di determinanti */
  DETERMINANTE *determinanti;
  /** array di coefficienti */
  TIPOFATTORE *coefficienti;
};

inline int operator !=( COUCHE a,  COUCHE b)
{
  int res=(a.n!=b.n || a.l!=b.l);
  return res;
}
