/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : mar mai  2 10:55:42 CEST 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include<nMatrix/nMatrix.h>
#include<nMatrix/nLapack.h>
#include<Sparsa/Sparsa.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"

#include"../libasfhfs/asfhfs.h"
#include<../LinearInterpolation/Linear_Interpolation.h>
char * utilizzo= "  D+ Dz D-   NumeroIngredienti ..... mat1base   peso1 .... matnbase   peson     \n"
								 "                               mat1exci  .... matnbase       dene temp e1 e2 np  fileallargamenti \n";
char opzioni[]="nientemomenti";


int main(int argc, char *argv[])
{
  cout << "Hello, World!" << endl;
  if (argc==1) {
    cout << utilizzo << endl;
    exit(0);
  }
  
  Sparsa3A dipoli[3];
  for(int i=0; i<3; i++) {
    dipoli[i].inizializza(argv[i+1]);
  }
  
  int nh;
  sscanf(argv[4],"%d",&nh);
  double pesi[nh];
  Sparsa3A Hbase, Hex;
  for(int i=0; i<nh; i++) {
    sscanf(argv[6+2*i],"%le",&pesi[i]);
  }
  
  for(int i=0; i<nh; i++) {
    cout << " aggiungo il file " <<argv[5+2*i] << "  con peso " <<pesi[i] << endl;
    Hbase.sommaFast( argv[5+2*i], pesi[i] );
  }
  
  for(int i=0; i<nh; i++) {
    cout << " aggiungo il file " <<argv[5+2*nh+i] << "  con peso " <<pesi[i] << endl;
    Hex.sommaFast( argv[5+2*nh+i], pesi[i] );
  }
  
  double DENE, temp;
  sscanf( argv[5+3*nh],    "%le",&DENE );
  sscanf( argv[5+3*nh+1],"%le",&temp );
  
  double e1,e2,ene;
  int    np;
  
  sscanf( argv[5+3*nh+2],"%le",&e1 );
  sscanf( argv[5+3*nh+3],"%le",&e2 );
  sscanf( argv[5+3*nh+4],"%d",&np );
  
  Linear_Interpolation<double,double>  allargamenti;
  allargamenti.read_file(argv[5+3*nh+5]);
  

  uMatrix<double> eVect, eVal;
  Risolutore H;
  H.inizializza(Hbase);
  H.diagonalizzaH(DENE, eVect, eVal );
  
  double sommapart=0;
  for(int k=0; k< eVal.rows(); k++) {
    double expo=-(eVal(k) -eVal(0))/temp ;
    if(expo>-12) {
      sommapart+=exp( - (eVal(k)-eVal(0))/temp);
    }
  }
  
  double *duma, *dumb, *dumbi, *imag;
  duma= new double [2*Hex.dim];
  dumb= new double [2* Hex.dim];
  memset(dumb,0,2* Hex.dim*sizeof(double));
  dumb[0]=1;
  dumbi= dumb+Hex.dim;
  imag= new double [ Hex.dim];
  FILE *res; 
  if( argc==5+3*nh+5+1) {
    res= fopen("risultato","w");
  } else if ( argc==5+3*nh+7+2) {
    res= fopen(argv[5+3*nh+7+1],"w");
  } else {
    printf(" ERROR \n");
    printf(utilizzo);
    exit(0);  
  }
  if(res==0) {
    printf("problema di apertura file \n");
    exit(0);

  }
  
  double ass[np][3];
  
  memset(ass,0, 3*np*sizeof(double) );
  cout << "eval.rows=" << eVal.rows() << endl;
  for(int k=0; k< eVal.rows(); k++) {
    double	enebase=eVal(k);
    double expo=-(enebase-eVal(0))/temp ;
    if(expo>-12) {
      cout << k << " " << exp(expo)/sommapart << endl;
    }		
  }	
  for(int k=0; k< eVal.rows(); k++) {
    for(int idip=0; idip<3; idip++) {		
      double enebase, peso;
      enebase=eVal(k);
      double expo=-(enebase-eVal(0))/temp ;
      if(expo>-12) {
	memset(duma,0,2* Hex.dim*sizeof(double) );
	dipoli[idip].Moltiplica(duma, eVect.address() + k*eVect.rows()  );
	peso=exp(-(enebase-eVal(0))/temp) /sommapart;
	
	
	LanczosSteps  steps;
	MatriceSparsa * shiftata;
	Hex.copiasu(shiftata);
	Hex.gohersch();
	double shift=-Hex.goherschMax() ;
	shiftata->trasforma(1.0,shift);
	int tospan= 250;
	steps.setMatrice(shiftata, tospan  );
	steps.setNoOldDiags();
	cout << " passeggio \n";
	double norma_duma = scalare(duma,duma, Hex.dim);
	steps.passeggia(0,tospan,duma );
	cout << " passeggio OK\n";
	
	delete shiftata;
	
	double d;
	double recscal(double *alpha, double *beta, int n, double wr, double wi);
	
	for(int ne=0; ne<np; ne++) {
	  ene= (ne*e2 + (np-ne-1)*e1)/(np-1);
	  
	  double epsilon= allargamenti(ene);
          cout << ene << " "<< epsilon << endl;
  
	  d=recscal(steps.alpha, steps.beta, tospan, enebase+ene+shift, epsilon );

	  ass[ne][idip]+= peso*d*norma_duma;


	}
	
      }
    } 
  }
  
  printf(" stampo\n");
  
  for(int ne=0; ne<np; ne++) {					
    ene= (ne*e2 + (np-ne-1)*e1)/(np-1);
    fprintf(res,"%e %e %e %e\n",ene*27.2, ass[ne][0],ass[ne][1],ass[ne][2]);
  }
  
  
  // fprintf(res," %e ", ampiezza );
  // fprintf(res,"\n");
  
  fclose(res);
  return EXIT_SUCCESS;
}






double recscal(double *alpha, double *beta, int n, double wr, double wi){
  complex<double> w(wr,wi);
  complex<double> res=0.0;
  for(int i=n-1; i>=0; i--) {
    if(i!=(n-1)) res=-beta[i]*beta[i]/res;
    res=res+alpha[i]-w;
  }
  return (1.0/res).imag();

}
