/***************************************************************************
                          hfs.h  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/


#define PARAM_UNDEFINED 0       // definizioni che servono 
#define PARAM_OCC      1        // per i potenziali parametrici
#define PARAM_DIFF     2
#define PARAM_OCC_DIFF 3

#define METODOLDA 1
#define METODOSOSTITUZIONE 2
#define METODOSOSTITUZIONENONLOC  3




#define SCAMBIONONLOCALE
#ifdef SCAMBIONONLOCALE
#include"wigner.h"
#endif

class asfhfs;

// *****************************************
// **  Atomo sferico di Hartree Fock

/**
Questa classe descrive un atomo sferico autoconsistente con un potenziale LDA. Per vedere come questo potenziale e calcolato vedere la funzione Atomo_sferico::ricalcola_v().
Delle estensioni a modelli piu complessi sono possibili, ma il piu ricorrente e' l'LDA.


Questa classe e' dotata di numerose funzioni membro, ma nella pratica solo alcune di esse sono utilizzate a livello superiore. Per esempio questi sono degli estratti da amarcord
<pre>
	// si crea un oggetto di tipo Atomo_sferico
	Atomo_sferico hfs;
  // On fixe les parametres. La memoire necessaire est allouee
  hfs.set_parametres(Z,  n_grille, norb);
  //  On dit a atomo quels etas on veut consider
  // noforb e loforb (array di interi) rappreseno i numeri quantici n ed l
  hfs.set_stati(  noforb,  loforb);
  //  Pour chaque etats on lui dit la quel c est l occupation
  // occupazioni e un array di double
  hfs.set_occ(occupazioni );
  //   cette instruction initialise la grille (grille logarithmique
  //      allant de ro -> rinf )
  hfs.set_grille(ro,rinf);
  // Cette fonction initialise le potentiel atomique
  hfs.set_pot_coul();
  hfs.find_wave_functions();
  hfs.consistenza( METODOSOSTITUZIONE ,1.0e-12,0.1);
  hfs.find_wave_functions();
  hfs.calcola_slater();
</pre>
*/

class Atomo_sferico 
{
protected:
	/** charge noyau	*/
  double Z;
	/** nombre depoints dans le grillage */
  int n_grille;
  /** la grille */
  double *x;
  /**  tout simplement 1/r^2 On le precalcul une fois pour toutes*/
  double *cnt;
   /**     le potentiel */        	
  double *v;
  /** v_old pour le iterations */
  double *v_old;
  /** Potenziale di scambio locale */
  double *vech;
	/**  Potenziale di correlazione(se si usa) */
  double *vcorr;
	/**   densita di carica  */
  double *rho;
	/**  Carica totale interna degli elettroni (no Z) */
  double *rhoint;
  /**  Potenziale carica esterna */
  double *vext;
	/**  Le potentiel non local: un array pour chaque etat*/
  double **v_non_local ;
  /** La densite pour chaque etat */
  double **rho_el;
	/** le potentiel de charge pour chaque etat; */
  double **v_el;
  /**  utilitario */
  double *rhodum;
  /**  utilitario */
  double *rhodumb;
	/** per le iterazioni */
  double **v_non_local_old;

  /** nombre de niveaux n,l */
  int n_stati;
	/** Si utilizza per mettere la parte cinetica */
  double **ykin;
  /**  y[h][i]=valeur de la fonction  du niveau  h dans le point i du grillage*/
  double **y;

  /** Auxiliare (Dirac, WKB etc ..) */
  double **y_aux ;

  int     *schro_start;
  int     *schro_end;
  int     *start;
  int     *end;

  /** Fonction d'onde Libre */
  double *wfunc_libre;
	/** Auxiliare (Dirac, WKB etc ..) */
  double *wfunc_libre_WKB_phase;
  /**  Auxiliare (Dirac, WKB etc ..) */
  double *wfunc_libre_WKB_amp;
  /**  Auxiliare (Dirac, WKB etc ..)  */
  double *wfunc_libre_aux1;
  /**  Auxiliare (Dirac, WKB etc ..) */
  double *wfunc_libre_aux2;

	/** Coefficient des ondes de Bessels  sferica sqrt(2/PI)*j */
  double aJ;
  /** Coefficient des ondes de Bessels sferica sqrt(2/PI)*j */
  double aY;

  /** dove parte la wkb della funzione libera */
  int     free_wkb_start;
  int     free_schro_start;
  int     free_schro_end;
  int     free_dirac_start;
  int     free_dirac_end  ;
   
 	/** occ[h]=nombre d'electrons dans le niveaux h*/
  double *occ;
 	/** N[h]= numero quant.prin.de l'etat h*/
  int *N;
 	/** L[h]= numero quant.sec.de l'etat  h*/
  int *L;
 	/**E[h]= energia stato h */
  double *E;

  double ***Kk;
 	/** Potenziale di scambio, k in x*/
  double ****Kkx;

  void alloca_nonloc();
  void libera_nonloc();

  void allocazione();            //- fonction qui alloue la memoire pour les *  
  void libera();            //- fonction qui libere la memoire pointe par les *

  
public:

  Atomo_sferico();                               //- constructeur
  ~Atomo_sferico();                              //- distructeur
  
  /** questa funzione assegna Z,n_grille e n_stati ed esegue
    le allocazioni di memoria necessarie.
    Gli stati sono intesi come soluzioni dell equazione di Schroedinger non relativistica.
    Sono quindi di tipo  (n,l)
    @param Zp carica del nucleo, inizializza il membro Z
    @param n_grillep  numero di punti della griglia radiale. Inizializza il membro n_grille
    @param n_statip   numero di stati n,l. Inizializza  il membro n_stati
  */
  void set_parametres(double Zp, int n_grillep, int n_statip);
  

  /** interroga il numero di punti griglia */
  inline int get_n_grille(){ return n_grille;}

  /** carica del nucleo */
  inline double getZ() {return Z;}

  /** questa funzione assegna per ogni livello il numero di elettroni presenti
      @param occp est un'array di double di lunghezza n_stati. Inizializza l'array membro occ
   */
  void set_occ(double *occp);

  /** assegna per ogni stato i numeri quantici n,l
     @param Np array di lunghezza n_stati. Inizializza l'array membro N
     @param Lp array di lunghezza n_stati. Inizializza l'array membro L
  */
  void set_stati( int *Np, int *Lp);

  /** assegna gli estremi della griglia,
    i punti intermedi sono assegnati con un magliaggio logaritmico
    La griglia est rappresentata dall'array double *x (funzione membro)
    @param a inizio in UA (raggio di Bhor==1)
    @param b fine   in UA
  */
  void set_grille(double a,double b);

  void set_grille(double a,double b, int nlog, double c);

  /** inizializza il potenziale con un array di lunghezza n_grille.
      Questa funzione inizializza i membri seguenti

      l'array v che e' il potenziale locale

      gli array v_non_local (che sono in numero di n_stati) che sono utili qualora
      si voglia calcolare l'atomo con un potenziale non locale (piu' sofisticato di LDA),
      sono messi a zero

      Ed anche v_old e v_non_local_old che servono per memorizzare v e v_nonlocal quando
      si itera cercando la consistenza al fine di verificare la convergenza.
      In realta altri metodi sono possibili. Attualmente si fa un test sull'energia
      totale.

  */
  void set_pot(double *p);

  /** inizializza v con Z/x, inizializza anche v_nonlocal
  */
  void set_pot_coul();

  /** inizializza v con la soluzione di TF per uno ione di carica Zi.
      Questa funzione sull'alfa si pianta per floating exception venente
      da fermidiracintegrals.f Per questa ragione in asfhfs.cc
      nel metodo asfhfs::inizializza_hfs si usa set_pot_coul();
  */
  void set_pot_tf(double Zi=0);


  /** Trova le soluzioni libere all'equazione di Schroedinger
      nel potenziale v.
      Questa funzione prende v, ci aggiunge la forza centrifuga

      <PRE>

 			for(int ix=0; ix < n_grille ; ix++)
    		{
      		VplsCnt[ix]=v[ix] + L*(L+1)*cnt[ix];
    		}
      </PRE>

      e risolve l'equazione di schroedinger per un'elettrone libero (nessuna condizione all'infinito
      <pre>
 				schrofreeWKB( ef, x , VplsCnt, wfunc_libre ,wfunc_libre_WKB_amp,
											wfunc_libre_WKB_phase,
	     								aJ,aY, free_wkb_start, n_grille,    L, 1 );
			</pre>
			Nella funzione schrofreeWKB la funzione d'onda e' data da double * wfunc_libre per i primi
			free_wkb_start punti (valore settato in uscita) ed in seguito da wfunc_libre_WKB_amp e wfunc_libre_WKB_phase.
			
			La funzione libera e' normalizzata in maniera tale che essendo aJ e aY i coefficienti delle funzioni
			di bessel sferiche sqrt(2/PI)*j e sqrt(2/PI)*y  descriventi il prolungamento oltre il limite della griglia,
			aj**2+ay**2 =1. Questo vuol dire che il comportamento asintotico e' proporzionale a un   sqrt(2/PI)*cos(r+fase)/r
			
			@param ef energia dell'elettrone libero
			@param L  momento angolare
  */
  void find_free_wave_function(double ef, double L );

  /** Trova le soluzioni all'equazione di Schroedinger
      nel potenziale v. Per ognuno degli n_stati stati n,l risolve l'equazione limitata
      dalla condizione di regolarita per r tendente a 0 e di nullita per r tendente a infinito
      in questa maniera
      <PRE>
  				void schro(double &E, double *r, double *V, double *Vnonloc ,double *y, int NGRID, int nsol,
	     								double l);
  				double VplsCnt[n_grille];
  				for(int is=0; is < n_stati;  is++)
    				{
      				for(int ix=0; ix < n_grille; ix++)
         				{
           				VplsCnt[ix]=v[ix] + L[is]*(L[is]+1)*cnt[ix];
         				}
      				schro( E[is], x , VplsCnt,v_non_local[is], y[is], n_grille,  N[is],  L[is]);
    				}
      </PRE>
      Le funzioni y sono normalizzate a 1  ( integrale di y**2 sulla griglia)


  */
  void  find_wave_functions();



  /** questa funzione calcola l'elemento dipolare fra le parti radiali dello stato legato is
      che si suppone essere stato calcolatodal metodo find_wave_functions() e messo nell'array y[is]
      e dello stato di elettrone libero contenuto negli array wfunc_libre ,wfunc_libre_WKB_amp,
			wfunc_libre_WKB_phase con passaggio a wkb alla posizione free_wkb_start.
			Lo stato libero si suppone essere stato calcolato dalla funzione schrofreeWKB
	*/
  double scalareFreeBoundR(int is);

  /**  stampa le funzioni d'onda
       su dei files. Il nome dei file
       e nel formato  nfN%dL%.wfunc.
       Ogni funzione avra il suo file
  */
  void stampa_wave_functions(char *nf);

  /** stampa la funzione d'onda libera
      su un  files. Il nome del file
      e' dato in argomento
  */
  void stampa_free_wave(char *nf, int ninterp=1 );


  /**
     calcola la parte cinetica per tutti gli stati . Da chiamarsi dopo find_wave_functions.
     La parte cinetica, frutto dell'applicazione dell'operatore laplaciano sulla funzione y[is] dello stato is,
     e' scritta come
		<pre>
	   ykin[is][i]=(E[is]-v[i])*y[is][i]-v_non_local[is][i];
		</pre>
		dove E[is] e' l'energia monoelettronica o piu correttamente il moltiplicatore
		di Lagrange del problema variazionale dante luogo alle equazioni di Hartree Fock.
		
		ykin contiene sia la parte radiale che angolare del laplaciano
		
  */
  void calcolakin();


  /**
		questa funzione da il campo elettrico nell'array Esfer, per delle occupazioni date
		dall'array oc di lunghezza n_stati. Il calcolo e' fatto sulla base delle funzioni
		y che si suppongono gia' calcolate. Questa funzione e' utile quando si vuole
		calcolare lo spin orbita. Le occupazioni di solito si danno con un elettrone in meno
		per lo stato di cui si sta calcolando lo spin orbita.
		
		ATTENZIONE: non uso piu' questa funzione. Questa funzione prendeva in conto anche lo scambio. Uso invece
		calcolaEsfericomixedNew che considera solo la parte elettrostatica ed e' piu corretto
	
	*/
  void calcolaEsfericomixed(double *oc, double *Esfer);

  /**
		questa funzione da il campo elettrico nell'array Esfer, per delle occupazioni date
		dall'array oc di lunghezza n_stati. Il calcolo e' fatto sulla base delle funzioni
		y che si suppongono gia' calcolate. Questa funzione e' utile quando si vuole
		calcolare lo spin orbita. Le occupazioni di solito si danno con un elettrone in meno
		per lo stato di cui si sta calcolando lo spin orbita.
		La funzione considera solo la parte elettrostatica ed e' piu corretto
	
	*/

  void calcolaEsfericomixedNew(double *oc, double *Esfer);


  /**
   Ricalcola il potenziale locale Coulomb + scambio.
   La coda e' completata da un potenziale coulombiano uguale a -(Ztot+1)/r
   dove Ztot e' la carica totale (nucle-elettroni).
   Il calcolo e' fatto assumendo le funzioni monoelettroniche y gia calcolate. Le occupazioni
   sono dati dall'array membro occ
   ed
  */
  void ricalcola_v();

  /**
   Ricalcola il potenziale locale Coulomb + scambio.
   La coda e' completata da un potenziale coulombiano uguale a -(Ztot+1)/r
   dove Ztot e' la carica totale (nucle-elettroni).
   A differenza di ricalcola_v() la carica non e' calcolata ma
   e' data in input dall'array  rho
  */
  void ricalcola_v(double *rho);


  /**
		questa funzione e' vuota
  */
  void ricalcola_v_nonloc();


  /**
       Questa funzione serve a smorzare le instabilita in fase di ricerca
       della autoconsistenza.
       Mischia il nuovo potenziale v  e il vecchio v_old e mette il risultato in v.

       <pre>
       v[i] -=(1-f)*(v[i]- v_old[i] );
       </pre>

       o in formato piu leggibile

       <pre>
       v[i]  = f* v[i] +  (1-f)* v_old[i] );
       </pre>
			
       dove f e' il parametro dato in argomento


  */
  void melange_new_old(double f);

  /**
    trova la autoconsistenza. La variabile metodo puo' essere uguale a METODOLDA, METODOSOSTITUZIONE
     oppure METODOSOSTITUZIONENONLOC.

     Metodo METODOSOSTITUZIONENONLOC non e' usato. Io uso sopratutto METODOSOSTITUZIONE. Infine METODOLDA
     puo' funzionare. Quest'ultimo effettua una ricerca del minimo dell'energia totale

	*/

  void consistenza(int metodo, double tol, double para=0.2); 

  /**
  	Stampa il potenziale locale e il potenziale di scambio sul file di nome nf
  */
  void stampa_local(char *nf);

  /**  da il numero di stati
  */

  inline int get_n_stati() { return n_stati;}

  /** da il numero di elettroni; */
  double getnel();
 
  /**  Da il moltiplicatore di Lagrange dello stato i */
  inline double get_energia(int i) { return E[i];};

  /** Energia totale  secondo il potenziale LDA*/
  double energiaLDA(int ricalcolav=1);

  /** Energia totale secondo il potenziale pot */
  double energiaLDApot(double *pot);
	/** return v ;*/
  inline double * getv() { return v ;};
	/** return v_old;*/
  inline double * getvold() { return v_old; };
	/** return x ;*/
  inline double * getx() { return x ;};
	/**  return occ ;*/
  inline double * getocc() { return occ ; }
	/**  return y ;*/
  inline double ** getpsi() { return y ;}

  void  calcolodegliR(int is,int it,
		      int iu,int iv,
		      int kmin, int kmax,
		      double *R )        ;


  /** per ora e' messo  a zero. Se lo si metto a uno nel potenziale LDA ci si trova anche un termine
      di correlazione fra elettroni. Preso da calcoli sapienti per un gas uniforme di elettroni.
      Il che pero non da dei bellissimi risultati
  */
  int CORRELAZIONE;


  /**
     calcola tutti gli integrali di slater e cioe

     double ***Kkx;  Integrali di Slater

     Kkx[i][j][l]

     e' l'integral di Slater di indice l fra gli stati i e j con j>=i

  */
  void calcola_slater();

  /** Energia totale secondo Slater */
  double energiaSlater();


	/**  Questo e' un oggetto della classe Wignercoef che serve ad ottenere i valori dei simboli 3J   */
  static Wignercoef trej;


  /** serializza l'atomo su un file */
  void serializza(fichier &f);


  friend class asfhfs;

};





