import types
from Numeric import array, Float32, zeros, ones
from PyDVT.Filter import Filter

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '10/12/2002'

DEBUG=0

class LeftRightFlipFilter(Filter):
	def __init__(self,source,synchronized=1,buffer_input=0):
		Filter.__init__(self,source,synchronized,buffer_input)

	def GetOutput(self):
		if DEBUG: print 'In LeftRightFlipFilter.GetOutput...'
		sel=self.GetInput()
		data=sel['data']	
		data=data.astype(Float32)
		if DEBUG: print type(data), data.shape,data[0,0]	
		if type(data)==types.NoneType: return
		
		outputData=zeros(data.shape)
		outputData=outputData.astype(Float32)
		i=0
		while i<data.shape[0]:
			outputData[:,data.shape[0]-1-i]=data[:,i]
			i=i+1
		
		if DEBUG: print outputData.shape, outputData[0,0]
			
		return {'data': outputData}
	
