"""
    MLabData.py 
    Data derived class to wrapp Numeric array   
"""

from PyDVT import __version__,__date__,__author__


################################################################################  
from Data import *
from Numeric import *
import types
import copy
################################################################################

SOURCE_TYPE = "ARRAY"


class MLabData(Data):
    """
    Specializes Data class in order to Wrap arrays.    
    Interface: Data class interface.
    """
    def __init__(self,array=None,SourceName=None, refresh_interval=None,info=None):
        """
	__init__(self,array=None,SourceName=None, refresh_interval=None,info=None)
        See Data.__init__
        """
        if(info is None):
            info = {}
        self.EdfObj=None
        info["Class"]="MLabData"        
        self.num_arrays=0
        self.torefresh=[]
        Data.__init__(self,refresh_interval,info)
        if( SourceName is not None):
            self.SetSource(source_name=SourceName)
        if(array is not None):
            self.LoadSource(array=array)

    def SetSource (self,source_name=None):
        self.SourceName=source_name
        self.Source=source_name
        return 1
    

    def GetSourceInfo (self):
        """
        Returns information about the MLabData object.
        To give application possibility to know about
        it before loading.
        Returns a dictionary with the keys "Size" (number of possible
        keys to this source) and "KeyList" (list of all available keys
        in this source). Each element in "KeyList" is an integer
        meaning the index of the array in the file.
        """        
        # if self.SourceName == None: return None
        NumImages=self.num_arrays
        source_info={}
        source_info["Size"]=NumImages
        source_info["KeyList"]=range(NumImages)
        return source_info        

    def LoadSource(self,key_list="ALL", append=0,invalidate=1, array=None):

        if(array is None):
            return
        if append==0:
            Data.Delete(self)
            self.num_arrays=0
            
        info={}
        info["SourceType"]=SOURCE_TYPE
        info["SourceName"]=self.SourceName
        info["Key"]=self.num_arrays
        info["Source"]=self.Source
        self.num_arrays=self.num_arrays+1
        print "self.num_arrays ", self.num_arrays
       
       
        self.AppendPage(info,array)        
        if invalidate: self.Invalidate()

        
    def UpdateAll(self):
        self.Invalidate()

    def UpdatePage(self, N):
        if type(N) is types.IntType: N=[N]
        for i in N :
           self.torefresh.append(i)


    def RefreshPage (source_obj,self,page):        
        if(page in self.torefresh):
            self.torefresh.remove(page)
            return 1
        else:
           return 0






        
