#!/usr/bin/env python

from sys import argv
from qt import *


class DropDemo(QListView):
    def __init__(self,parent=None,name=None):
        QListView.__init__(self,parent,name)
        # self.setAcceptDrops(1)
        self.setGeometry(10,10,100,60)
        self.addColumn("Column 1")
        self.i = QListViewItem(self, "Hello")
        self.ii = QListViewItem(self, "Hello 2")
        r = self.itemRect(self.i)
        r = self.itemRect(self.ii)
        
    def dragEnterEvent(self, event):
        event.accept(QTextDrag.canDecode(event))
  
    def dropEvent(self, event):
        print " DROP"
        text = QString()
        pos = QPoint(event.pos().x(), event.pos().y() - self.header().height())
        item = self.itemAt(pos)
        text=QString()
 
    def mouseMoveEvent(self, event):
        print " drag"
        self.startDrag()

    def startDrag(self):
        d = QTextDrag("blabla",self) # keep a reference to d
        d.dragCopy()
 
if __name__ == '__main__':
    a = QApplication(argv)
    w = DropDemo()
    w.setCaption("Drag and Drop Test")
    w.resize(120,80)
    a.setMainWidget(w)
    w.show()
    a.exec_loop()
        

