from sys import *
from copy import *
import NumericA
from Numeric import *
from  arrayfns  import *            
#
from umathextra import *

from Dabax import *
from PyFullerton  import *

#######################################################################
# specify here the scatterers
#

tf0= Dabax_f0_Table("f0_WaasKirf.dat")
tf12=Dabax_f1f2_Table("f1f2_Sasaki.dat")


Ti_a=ScattererFromTable(tf0,tf12  ,"Ti",DWsigma=DW2sigma(0.5),convention="-iKx",)
Ba_a=ScattererFromTable(tf0,tf12  ,"Ba",DWsigma=DW2sigma(0.5),convention="-iKx",)
O_a =ScattererFromTable(tf0,tf12  ,"O" ,DWsigma=DW2sigma(0.5),convention ="-iKx",)
Sr_a=ScattererFromTable(tf0,tf12  ,"Sr",DWsigma=DW2sigma(0.5),convention ="-iKx",)


Srll=[  (0.,0.43),(0.,0.2),(0.0,0.0)         ]
Ball=[  (0,-0.006),(0,0.003),(0.0,0.0)         ]
Ball=Srll
pp1= Perov_Planes()
pp1.LL=Srll
pp1.HH=Ball

pp2= Perov_Planes()
pp2.L=Ball
pp2.H=Srll

i1= Fuller_Interface(Perov_Planes=pp1)
i2= Fuller_Interface(Perov_Planes=pp2)
    
SrTiO3_Plane = Fuller_PerovskitePlane( Oxygen=O_a , External=Ti_a, Internal=Sr_a,
               Spacing=3.92, InPlaneDensity=1.0, PesiOxygen=[0.5,2.0,0.5])

BaTiO3_Plane = Fuller_PerovskitePlane( Oxygen=O_a , External=Ti_a, Internal=Ba_a,
               Spacing=3.975, InPlaneDensity=1.0, PesiOxygen=[0.5,2.0,0.5])


SrTiO3_Layer  = Fuller_LayerM_XXI( Nplanes= 4.1 , SigmaNplanes=0.5,Plane=SrTiO3_Plane)
BaTiO3_Layer  = Fuller_LayerM_XXI( Nplanes= 13.3, SigmaNplanes=1.0,Plane=BaTiO3_Plane)


period    = (i1+BaTiO3_Layer+
             i2+SrTiO3_Layer )


thetalist=0.5*arrayrange(9.5,12.6,0.02)*math.pi/180.0

# thetalist=array([ theta for theta in arrayrange(5,25,0.0133)*math.pi/180.0 ])

lambdalist=12398.52/16000.0*ones(len(thetalist) ) 

res=(period .DoCalculation( lambdalist , thetalist , 15  , L=None ,  sigmatheta=0.0001,
                              pol='M', CRough=0 ))

thetalist=thetalist*2.0

f=open("curva","w")
for i in range (0,len(thetalist)):
    f.write("%e %e\n"% (thetalist[i]*180.0/math.pi,res[i]  ))

print "finished  calculations"















