import Hilbertxx
import Sparsa
import spectrumFunction
import Numeric
from Minimiser import par
import arrayfns
import math
import time
import string
import math
from Minimiser import *


import INSTALLATIONzhang

# from   mainfunctionsCoK import *


def AsciiMatrixReader(filename):

   """
	def function_name(filename):

	 reads a file containing an ascii matrix.
         Carriage return split lines
	EXAMPLE (MLAB):

a=MLab.AsciiReader("toto.txt")

        

   """  

   f=open(filename,"r")
   datas=f.read()
   datalines=string.split(datas,"\n")

   Np=len(datalines)

   data=map(string.split,datalines)

   dim=len(data[0])
   for i in range(Np):
     data[i]=map(string.atof,data[i])

   newdata=[]
   for i in range(Np):
     if(len(data[i])==dim):
         newdata.append(data[i])
   data=Numeric.array(newdata)


   return data


def AsciiMatrixWriter(A, filename, format="%s"):


   if(len(A.shape)==1):
	   f=open(filename,"w")
	   for tok in A:
              f.write(format % tok)
              f.write(" ")
           f.close()
   elif(    len(A.shape)==2):
	   f=open(filename,"w")
	   for Al in A:
		   for tok in Al:
        	      f.write(format % tok)
        	      f.write(" ")
                   f.write("\n")
           f.close()
   else:
           raise "  wrong shape for object A in routine AsciiMatrixWriter"

 



##        add=415.22*(  scatterer.F_Lambda(wavelenght) )*( 
##            wavelenght*wavelenght/12398.52/12398.52/mass)


class SpettroZhang:

  def __init__(self, reduc=None, ET=None,    all1=None, all2=None, El2l3=None, shift2=None, factor=None,
                xdata=None, ydata=None,
	        eedge=None, edgeH1=None, edgeH2=None, edgeWidth=None, reduc55=None , 
		SOfact=Variable(1,0,0) , spinH=Variable(0,0,0) , thetaH=Variable(0,0,0),  Temp=0.025
	 ):

        self.paranames=[  "reduc",  "ET",  "all1", "all2", "El2l3" , "shift2","factor" ,"xdata","ydata",
		"eedge" , "edgeH1", "edgeH2","edgeWidth" , "reduc55", "SOfact", 
                          "spinH", "thetaH",]

	for name in self.paranames:
	    setattr(self, name, locals()[name])  

        self.Temp=Temp



  def error(self, ):
   ##############################################################################
   ## parametri
   ##
   reduc=  ET=  all1= all2= El2l3 = shift2=factor =xdata=ydata=eedge = edgeH1= edgeH2=edgeWidth = reduc55= SOfact= spinH= thetaH= Ez2Spin= Ex2Spin=0.0
   for name in self.paranames:
	 exec("%s  =   par(getattr(self, name)  ) "   %name)

   for name in self.paranames:
	print name," = ",  par(getattr(self, name)  )


   ######################################################################################
   ## 
   ##
   sinH=math.sin(thetaH*math.pi/180)
   cosH=math.cos(thetaH*math.pi/180)
   
   coeff = [ 0.0 *reduc55  *27.2,        # F2dd
             0.0*reduc55  *27.2  ,       # F4dd
             0.00356527 *27.2*par(self.SOfact) , # SO_3d
             ET,                         # crystal field
             spinH*cosH ,                # SpinH
             spinH*sinH/2.0,             # SpinHp
             spinH*sinH/2.0              # SpinHm
    ]


   coeff_exc= [  0.0 *reduc55 *27.2 ,                    # F2dd
		 0.0*reduc55  *27.2  ,                   # F4dd
		 0.00356527 *27.2 *par(self.SOfact),     # SO_3d
                 0.366847*27.2,                          # SO_2p
		 0.268426*reduc *27.2 ,                  # F2pd
                 0.204775 *reduc  *27.2  ,               # G1pd
                 0.116557*reduc *27.2   ,                # G3pd
		 ET,                                     # excited_basis_T
		 spinH*cosH ,                            # SpinH
                 spinH*sinH/2.0,                         # SpinHp
                 spinH*sinH/2.0                          # SpinHm
              ]



   result3=self.spectrum( INSTALLATIONzhang.datadir, coeff, coeff_exc, shift2, factor)

   self.ycalcPlus  =result3[1].imag
   self.ycalcMinus =  result3[0] .imag
   self.x3         = result3[-1]







   add= self.xdata * 0

   if(eedge is not None):
      x=(self.xdata-eedge)/edgeWidth
      add = edgeH1*(2* Numeric.arctan(x)/ math.pi) *Numeric.less(0.0,x)
      x=(self.xdata-eedge - 1.5* 0.260238  *27.2 )/edgeWidth
      add = add+edgeH2*(2* Numeric.arctan(x)/ math.pi) *Numeric.less(0.0,x)

    
   self.add = add
   self.fondo=add
   self.ycompPlus = arrayfns.interp(self.ycalcPlus , self.x3, self.xdata  ) 
   self.ycompPlus = self.ycompPlus+add

   self.ycompMinus = arrayfns.interp(self.ycalcMinus , self.x3, self.xdata  ) 
   self.ycompMinus = self.ycompMinus+add



     




  def spectrum(self, repe, coeff, coeff_exc, shift, factor, s2s=0):


   t_base = Hilbertxx.Hxx_TransitionMatrix(1)
   t_excited = Hilbertxx.Hxx_TransitionMatrix(1)

   names = [       "base_basis_F2dd",  
				 "base_basis_F4dd",
				 "base_basis_SO_3d",
                   "base_basis_T",
				 "base_basis_SpinH", 
				 "base_basis_SpinHp", 
				 "base_basis_SpinHm", 
                  ]

   for i in range(len(coeff) ):
      if( coeff[i] !=0.0) :
        t_base.Read_add( repe+names[i], coeff[i], 0)

   names_exc=  [ "excited_basis_F2dd",  
			"excited_basis_F4dd",
			"excited_basis_SO_3d",
			"excited_basis_SO_2p",
			"excited_basis_F2pd",
			"excited_basis_G1pd",
			"excited_basis_G3pd",
			"excited_basis_T",
 			"excited_basis_SpinH",
		        "excited_basis_SpinHp", 
			"excited_basis_SpinHm", 
               ]

   for i in range(len(coeff_exc) ):
      if( coeff_exc[i] !=0.0) :
       t_excited.Read_add( repe+names_exc[i], coeff_exc[i], 0)


   ars_base=t_base.create_3Array_and_Clean()
   ars_ecci=t_excited.create_3Array_and_Clean()


   S_base=Sparsa.Sparsa3A( ars_base[2], ars_base[0], ars_base[1] )
   S_ecci=Sparsa.Sparsa3A( ars_ecci[2], ars_ecci[0], ars_ecci[1] )

   dipoliNames= [ "DipMinus_base_excited","DipPlus_base_excited","DipZero_base_excited"]

   dipS=[]
   t_dip = Hilbertxx.Hxx_TransitionMatrix(1) 

   t_dip.Read_add( repe+dipoliNames[1], 1.0, 0)
   ars = t_dip.create_3Array_and_Clean()
   dipS.append(Sparsa.Sparsa3A( ars[2], ars[0], ars[1] ) )

   t_dip.Read_add( repe+dipoliNames[2], 1.0, 0)
   ars = t_dip.create_3Array_and_Clean()
   dipS.append(Sparsa.Sparsa3A( ars[2], ars[0], ars[1] ) )




   allX=Numeric.array([-100000.0, par(self.El2l3)-0.2-shift*0 , par(self.El2l3)+0.2-shift*0, 100000.0])
   allY=Numeric.array([par(self.all1),par(self.all1),par(self.all2),par(self.all2) ])

   print " SPECTRUMFUNCTION"

   result = spectrumFunction.spectrumFunctionC( dipS,S_base, S_ecci, 0.1, par(self.Temp), -0.1,0.1,500,  
	allX, allY   )

   result[-1][:]=result[-1]+shift

   for i in range(len(result)-1) :
      result[i][:] = result[i] *factor

   return result




def test():
  from Minimiser import Variable

  import comandi
  reduc=Variable(0.65,0,0)
  Dq    =Variable(0.0,0.0,0.0)
  Ds    =Variable(0.0,0.0,0.0)
  Dt     =Variable(0.0,0.0,0.0)
  all1   =Variable(3.0,0,0)
  all2   = Variable(3.0,0,0)
  El2l3 = Variable(  100.0,0,0 )
  shift=Variable(0.0,0.0,0.0)
  factor     =Variable(0.0,0.0,0.0)


  spobj = SpettroMnS(reduc, Dq, Ds, Dt, all1, all2, El2l3 , shift, factor )
  result=spobj.spectrum()
  return result

if __name__=="__main__":
  result = test()
  print len(result)














