#!/bin/bash
# Bash postinstall script.  Since setup.exe 2.457.2.2 insists on using
# /bin/sh, and .bat scripts don't know about cygwin paths, this is a two-stage
# install: this script updates 01bash.bat, then that script sources the real
# postinstall in /etc/profile.d/00bash.sh with bash.  setup.exe 2.510.2.2
# and beyond use /bin/bash, so in 2007, it might be time to swap back to
# a single postinstall shell script, instead of the .bat hack.

# Work locally
cd /etc/postinstall
# Find the windows path to bash.  Mind those pesky backslashes.
bashpath=$(cygpath -w /bin/bash.exe | sed -e 's,\\,\\\\,g')
# If someone reruns this, 01bash.bat may have been renamed.
[[ -f ./01bash.bat ]] || {
  if [[ -f ./01bash.bat.done ]] ; then
    echo "$0: 01bash.bat is already marked done, quitting now"
    exit 0
  else
    echo "$0: 01bash.bat is missing" >&2
    exit 1
  fi
}
# Create the proper .bat script; set TMPDIR to ensure working in-place edit.
TMPDIR=. sed -i -e "/^echo/d; s|REM BASHPATH|$bashpath|" ./01bash.bat
