%module interpola
%{
      #include "interpola.h"
%}



%{
#include <Numeric/arrayobject.h> 



%}

%include typemaps.i

%init %{	
  import_array();
%}	




%typemap(in) (int  n, int  m,double * Array2DdataY) (PyArrayObject* tmp = NULL, int dimlead=0 ,int dimsecond=0  ) {
  tmp = (PyArrayObject *)PyArray_ContiguousFromObject($input, PyArray_DOUBLE, 2, 2);
  if(tmp == NULL) return NULL;
  $1  = dimlead = tmp->dimensions[0];
  $2  =dimsecond  = tmp->dimensions[1];
  $3 = (double *)tmp->data;
}
%typemap(freearg) (int  n, int  m,double * Array2DdataY) {Py_DECREF(tmp$argnum);}


%typemap(in) (double *Array1DDataX) (PyArrayObject* tmp = NULL ) {
  tmp = (PyArrayObject *)PyArray_ContiguousFromObject($input, PyArray_DOUBLE, 1, 1);
  if( tmp->dimensions[0] != dimlead1 ) {
    PyErr_SetString(PyExc_ValueError, "Vectors 2 must be same length than vector 1 in interpola .");
    return NULL;
  }
  $1  = (double *)tmp->data;	
}
%typemap(freearg) (int  n, int  m,double * Array2DdataY) {Py_DECREF(tmp$argnum);}


%typemap(in) ( int nr, double *Array1DDataxinterp) (PyArrayObject* tmp = NULL, int diminterp ) {
  tmp = (PyArrayObject *)PyArray_ContiguousFromObject($input, PyArray_DOUBLE, 1, 1);
  if(tmp == NULL) return NULL;
  $1  = diminterp = tmp->dimensions[0];
  $2 = (double *)tmp->data;
}



%typemap(in, numinputs=0) (  double *interpout  )  {
  $1 = new double [diminterp3 * dimsecond1 ];  // questa istruzione va poi spostata a mano modificando il wrapper generato
} 

%typemap(argout, fragment="t_output_helper") ( double *interpout )  {
  int nd=2;
  int dims[2];
  PyObject *arr_a;
  dims[0]= diminterp3 ;
  dims[1]= dimsecond1  ;
  arr_a = PyArray_FromDims(nd,dims,PyArray_DOUBLE ) ;
  memcpy( ((PyArrayObject *) arr_a)->data, $1 ,  diminterp3 * dimsecond1 *sizeof(double) );
  delete [] $1  ;	
  resultobj = t_output_helper(resultobj,arr_a );
} 


void interpolad(int n,int m,  double *Array2DdataY, double *Array1DDataX , int nr, double *Array1DDataxinterp, double *interpout);


// void interpolaD(int n,int m,  complex<double> *Y, double *X, int nr, double *x, complex<double> *res);
